#include <QObject>
#include <QMaemo5InformationBox>
#include <QFile>
#include <QDir>
#include <QDebug>
#include <QProcess>
#include <QTextStream>

#include "datadownloader.h"
#include "itfiles.h"

ITFiles::ITFiles(QObject *parent) : DataDownloader(parent, "/opt/showtime/data/it/"), HELPERPATH("/opt/showtime/helper/")
{
	_settingsFile = new QFile(QString(DATAPATH) + ".it");
	_channelFile = QString(DATAPATH) + ".it_channel_list";
	initSettings();
}

void ITFiles::initSettings()
{
	// just call the parent init settings
	// nothing specific to IT
	DataDownloader::initSettings();
}

QUrl ITFiles::getUrl()
{
	QUrl url;

	QString requestChannelCode = _channelCodeMap[_requestChannel];

	if ( !_useLocal )
		url.setUrl(QString("http://www.xmltvepg.nl/rytecxmltvskyit.gz?APP=SHOWTIME") );
	else
		url.setPath(QString(""));

	return url;
}

ITFiles::~ITFiles()
{
}

QString ITFiles::finishedDownload(QString channel, QIODevice *source)
{
	channel = "dummy";
	QString filename = saveZipFile(channel, source); 

	// this method will split the huge single xml file per channel
	// be patient this takes time
	splitXMLTVFile(filename);

	return filename;
}

void ITFiles::setInput(DownloadInput d)
{
	DataDownloader::setInput(d);
}

void ITFiles::sendRecordMsg(QStringList data)
{
}

void ITFiles::sentRecordMsg(int exitCode, QProcess::ExitStatus exitStatus)
{
}
