#ifndef UKFILES_H
#define UKFILES_H

#include <QObject>
#include <QStringList>
#include <QSet>
#include <QUrl>
#include <QMap>
#include <QProcess>

class QIODevice;

#include "datadownloader.h"

class UKFiles : public DataDownloader
{
    Q_OBJECT

public:
    UKFiles( QObject *parent );
    virtual ~UKFiles();
	virtual QUrl getUrl();
	void initSettings();
	virtual void setInput(DownloadInput d);
	virtual QString finishedDownload(QString channel, QIODevice *source);
	void sendRecordMsg(QStringList data);
	virtual int timeZoneOffset() { return 0; /*-1;*/ } // return -1 since data is generated in belgium which is 1 hr ahead of UK

signals:

public slots:

private slots:
	void sentRecordMsg(int exitCode, QProcess::ExitStatus exitStatus);

protected:
	void updateDownloadIndexes();

private:
	const char* HELPERPATH;
};

#endif // UKFILES_H
