#include <QObject>
#include <QMaemo5InformationBox>
#include <QFile>
#include <QDir>
#include <QDebug>
#include <QProcess>
#include <QTextStream>

#include "datadownloader.h"
#include "myfiles.h"

MYFiles::MYFiles(QObject *parent) : DataDownloader(parent, "/opt/showtime/data/my/"), HELPERPATH("/opt/showtime/helper/")
{
	_settingsFile = new QFile(QString(DATAPATH) + ".my");
	_channelFile = QString(DATAPATH) + ".my_channel_list";
	initSettings();
}

void MYFiles::initSettings()
{
	// just call the parent init settings
	// nothing specific to MY
	DataDownloader::initSettings();
}

QUrl MYFiles::getUrl()
{
	QUrl url;

	QString requestChannelCode = _channelCodeMap[_requestChannel];

	if ( !_useLocal )
		url.setUrl(QString("http://astrorss2xmltv.appspot.com/xmltv.xml.gz?APP=SHOWTIME") );
	else
		url.setPath(QString(""));

	return url;
}

MYFiles::~MYFiles()
{
}

QString MYFiles::finishedDownload(QString channel, QIODevice *source)
{
	channel = "dummy";
	QString filename = saveZipFile(channel, source);

	// this method will split the huge single xml file per channel
	// be patient this takes time
	splitXMLTVFile(filename);

	return filename;
}

void MYFiles::setInput(DownloadInput d)
{
	DataDownloader::setInput(d);
}

void MYFiles::sendRecordMsg(QStringList data)
{
}

void MYFiles::sentRecordMsg(int exitCode, QProcess::ExitStatus exitStatus)
{
}
