#ifndef MISCSETTINGSWINDOW_H
#define MISCSETTINGSWINDOW_H

#include "settings.h"
#include "misc.h"

class QLabel;
class QMaemo5ValueButton;

class MiscSettingsWindow : public SettingsWindow 
{
    Q_OBJECT

public:
    MiscSettingsWindow(QMainWindow* parent);

	~MiscSettingsWindow();

public slots:

signals:
	void clicked();


private slots:
	void setLandscape();
	void setPortrait();
	void setAuto();
	void setEventOnly();
	void setEventAndAlarm();
	void setShowPast();
	void setHidePast();
	void setStartPrimeTime();
	void setEndPrimeTime();
	void setIconSet1();
	void setIconSet2();
	void setIconSet3();
	void setIconSet4();
	void setDailyMode();
	void setSearchMode();
	void setCurrentMode();
	void setIconSet(QString iconset);
	void cancel();
	void save();

private: // functions

private:
	const char *ICONPATH;
	QLabel* preview1;
	QLabel* preview2;
	QLabel* preview3;
	QLabel* preview4;
	QMaemo5ValueButton* startTimeSelector;
	QMaemo5ValueButton* endTimeSelector;
};

#endif // MISCSETTINGSWINDOW_H
