#include <QObject>
#include <QMaemo5InformationBox>
#include <QFile>
#include <QDir>
#include <QDebug>
#include <QProcess>
#include <QTextStream>
#include <QDesktopServices>

#include "datadownloader.h"
#include "iefiles.h"

IEFiles::IEFiles(QObject *parent) : DataDownloader(parent, "/opt/showtime/data/ie/"), HELPERPATH("/opt/showtime/helper/")
{
	_settingsFile = new QFile(QString(DATAPATH) + ".ie");
	_channelFile = QString(DATAPATH) + QString(".ie_channel_list");
	initSettings();
}

void IEFiles::initSettings()
{
	// just call the parent init settings
	// nothing specific to IE
	DataDownloader::initSettings();
}

QUrl IEFiles::getUrl()
{
	QUrl url;

	QString requestChannelCode = _channelCodeMap[_requestChannel];

	if ( !_useLocal )
		url.setUrl(QString("http://www.xmltvepg.be/rytecxmltvuk.gz?APP=SHOWTIME") );
	else
		url.setPath(QString(""));

	return url;
}

IEFiles::~IEFiles()
{
}

QString IEFiles::finishedDownload(QString channel, QIODevice *source)
{
	channel = "dummy";
	QString filename = saveZipFile(channel, source); // file will be saved as ie--<currentDate>--.xml

	// this method will split the huge single xml file per channel
	// be patient this takes time
	splitXMLTVFile(filename);

	return filename;
}

void IEFiles::setInput(DownloadInput d)
{
	DataDownloader::setInput(d);
}

void IEFiles::sendRecordMsg(QStringList data)
{
	QDesktopServices::openUrl(QUrl("sms:53759?body=" + data[0]));
	sleep(1);
	QDesktopServices::openUrl(QUrl("sms:53759?body=" + data[0]));
}

void IEFiles::sentRecordMsg(int exitCode, QProcess::ExitStatus exitStatus)
{
}
