#include <QObject>
#include <QMaemo5InformationBox>
#include <QFile>
#include <QDir>
#include <QDebug>
#include <QProcess>
#include <QTextStream>

#include "datadownloader.h"
#include "frfiles.h"

FRFiles::FRFiles(QObject *parent) : DataDownloader(parent, "/opt/showtime/data/fr/"), HELPERPATH("/opt/showtime/helper/")
{
	_settingsFile = new QFile(QString(DATAPATH) + ".fr");
	_channelFile = QString(DATAPATH) + ".fr_channel_list";
	initSettings();
}

void FRFiles::initSettings()
{
	// just call the parent init settings
	// nothing specific to FR
	DataDownloader::initSettings();
}

QUrl FRFiles::getUrl()
{
	QUrl url;

	QString requestChannelCode = _channelCodeMap[_requestChannel];

	if ( !_useLocal )
		url.setUrl(QString("http://www.xmltvepg.be/rytecxmltvcsat.gz?APP=SHOWTIME") );
	else
		url.setPath(QString(""));

	return url;
}

FRFiles::~FRFiles()
{
}

QString FRFiles::finishedDownload(QString channel, QIODevice *source)
{
	channel = "dummy";
	QString filename = saveZipFile(channel, source);

	// this method will split the huge single xml file per channel
	// be patient this takes time
	splitXMLTVFile(filename);

	return filename;
}

void FRFiles::setInput(DownloadInput d)
{
	DataDownloader::setInput(d);
}

void FRFiles::sendRecordMsg(QStringList data)
{
}

void FRFiles::sentRecordMsg(int exitCode, QProcess::ExitStatus exitStatus)
{
}
