#ifndef REGIONWINDOW_H
#define REGIONWINDOW_H

#include <QtGui/QMainWindow>
#include <QPushButton>
#include <QToolButton>
#include <QHBoxLayout>

#include "settings.h"

class QWidget;

class MyToolButton : public QToolButton
{
public:
	MyToolButton(QIcon icon, QString text, QMainWindow* parent) : QToolButton(parent)
	{
		setToolButtonStyle(Qt::ToolButtonTextUnderIcon);
		setIcon(icon);
		setText(text);
		setAutoRaise(true);
		setIconSize(QSize(150, 150));
	}

	~MyToolButton() { };
};

class RegionWindow : public SettingsWindow 
{
    Q_OBJECT

public:
    RegionWindow(QMainWindow* parent); 

    ~RegionWindow();

	QStringList getRegionList()
	{
		QStringList list;
		list << "UK" << "AU" << "NZ" << "SE" << "DE" << "FR" << "ES" << "IT" << "HR" << "SI" << "DK" << "NL" << "BE" << "NO" << "RU" << "MY" << "ZA" << "PL" << "FI" << "IE";
		return list;
	}

public slots:

private slots:
	void setUK();
	void setAU();
	void setNZ();
	void setSE();
	void setDE();
	void setFR();
	void setES();
	void setIT();
	void setHR();
	void setSI();
	void setDK();
	void setNL();
	void setBE();
	void setNO();
	void setRU();
	void setMY();
	void setZA();
	void setPL();
	void setFI();
	void setIE();
	void setRegion(QString region);

signals:
	void clicked();

private: // functions

private:
	const char *FLAGPATH;
};

#endif // REGIONWINDOW_H
