#include <QObject>
#include <QMaemo5InformationBox>
#include <QFile>
#include <QDir>
#include <QDebug>
#include <QProcess>
#include <QTextStream>

#include "datadownloader.h"
#include "plfiles.h"

PLFiles::PLFiles(QObject *parent) : DataDownloader(parent, "/opt/showtime/data/pl/"), HELPERPATH("/opt/showtime/helper/")
{
	_settingsFile = new QFile(QString(DATAPATH) + ".pl");
	_channelFile = QString(DATAPATH) + ".pl_channel_list";
	initSettings();
}

void PLFiles::initSettings()
{
	// just call the parent init settings
	// nothing specific to PL
	DataDownloader::initSettings();
}

QUrl PLFiles::getUrl()
{
	QUrl url;

	QString requestChannelCode = _channelCodeMap[_requestChannel];

	if ( !_useLocal )
		url.setUrl(QString("http://www.xmltvepg.be/rytecxmltvpoland.gz?APP=SHOWTIME") );
	else
		url.setPath(QString(""));

	return url;
}

PLFiles::~PLFiles()
{
}

QString PLFiles::finishedDownload(QString channel, QIODevice *source)
{
	channel = "dummy";
	QString filename = saveZipFile(channel, source); 

	// this method will split the huge single xml file per channel
	// be patient this takes time
	splitXMLTVFile(filename);

	return filename;
}

void PLFiles::setInput(DownloadInput d)
{
	DataDownloader::setInput(d);
}

void PLFiles::sendRecordMsg(QStringList data)
{
}

void PLFiles::sentRecordMsg(int exitCode, QProcess::ExitStatus exitStatus)
{
}
