#include <QObject>
#include <QMaemo5InformationBox>
#include <QFile>
#include <QDir>
#include <QDebug>
#include <QProcess>
#include <QTextStream>

#include "datadownloader.h"
#include "nzfiles.h"

NZFiles::NZFiles(QObject *parent) : DataDownloader(parent, "/opt/showtime/data/nz/"), HELPERPATH("/opt/showtime/helper/")
{
	_settingsFile = new QFile(QString(DATAPATH) + ".nz");
	_channelFile = QString(DATAPATH) + ".nz_channel_list";
	initSettings();
}

void NZFiles::initSettings()
{
	// just call the parent init settings
	// nothing specific to nz
	DataDownloader::initSettings();
}

QUrl NZFiles::getUrl()
{
	QUrl url;

	QString requestChannelCode = _channelCodeMap[_requestChannel];
	_downloadStartIndex = QDate::currentDate().daysTo(_requestDate);
	// if the time of day in NZ is between 0 and 7am then get the next index as data is generated only at 6am in the morning
	if ( QTime::currentTime().hour() >= 0 && QTime::currentTime().hour() <= 7 )
		_downloadStartIndex++;

	if ( !_useLocal && _downloadStartIndex < 7 )
		url.setUrl(QString("http://download.xmltv.co.nz/?provider=telstra&channels=%1&days=%2&APP=SHOWTIME").arg(requestChannelCode).arg(_downloadStartIndex) );
	else
		url.setPath(QString(""));

	return url;
}

NZFiles::~NZFiles()
{
}

QString NZFiles::finishedDownload(QString channel, QIODevice *source)
{
	QString filename = saveFile(channel, source);
	return filename;
}

void NZFiles::setInput(DownloadInput d)
{
	DataDownloader::setInput(d);
}

void NZFiles::sendRecordMsg(QStringList data)
{
}

void NZFiles::sentRecordMsg(int exitCode, QProcess::ExitStatus exitStatus)
{

}
