#include <QObject>
#include <QMaemo5InformationBox>
#include <QFile>
#include <QDir>
#include <QDebug>
#include <QProcess>
#include <QTextStream>

#include "datadownloader.h"
#include "esfiles.h"

ESFiles::ESFiles(QObject *parent) : DataDownloader(parent, "/opt/showtime/data/es/"), HELPERPATH("/opt/showtime/helper/")
{
	_settingsFile = new QFile(QString(DATAPATH) + ".es");
	_channelFile = QString(DATAPATH) + ".es_channel_list";
	initSettings();
}

void ESFiles::initSettings()
{
	// just call the parent init settings
	// nothing specific to ES(germany)
	DataDownloader::initSettings();
}

QUrl ESFiles::getUrl()
{
	QUrl url;

	QString requestChannelCode = _channelCodeMap[_requestChannel];

	if ( !_useLocal )
		url.setUrl(QString("http://www.xmltvepg.be/rytecxmltvdplus.gz?APP=SHOWTIME") );
	else
		url.setPath(QString(""));

	return url;
}

ESFiles::~ESFiles()
{
}

QString ESFiles::finishedDownload(QString channel, QIODevice *source)
{
	channel = "dummy";
	QString filename = saveZipFile(channel, source); 

	// this method will split the huge single xml file per channel
	// be patient this takes time
	splitXMLTVFile(filename);

	return filename;
}

void ESFiles::setInput(DownloadInput d)
{
	DataDownloader::setInput(d);
}

void ESFiles::sendRecordMsg(QStringList data)
{
}

void ESFiles::sentRecordMsg(int exitCode, QProcess::ExitStatus exitStatus)
{
}
