#include <QObject>
#include <QMaemo5InformationBox>
#include <QFile>
#include <QDir>
#include <QDebug>
#include <QProcess>
#include <QTextStream>

#include "datadownloader.h"
#include "nlfiles.h"

NLFiles::NLFiles(QObject *parent) : DataDownloader(parent, "/opt/showtime/data/nl/"), HELPERPATH("/opt/showtime/helper/")
{
	_settingsFile = new QFile(QString(DATAPATH) + ".nl");
	_channelFile = QString(DATAPATH) + ".nl_channel_list";

	initSettings();
}

void NLFiles::initSettings()
{
	// just call the parent init settings
	// nothing region specific 
	DataDownloader::initSettings();
}

QUrl NLFiles::getUrl()
{
	QUrl url;

	QString requestChannelCode = _channelCodeMap[_requestChannel];

	if ( !_useLocal )
		url.setUrl(QString("http://www.xmltvepg.be/rytecxmltvbenl.gz?APP=SHOWTIME") );
	else
		url.setPath(QString(""));

	return url;
}

NLFiles::~NLFiles()
{
}

QString NLFiles::finishedDownload(QString channel, QIODevice *source)
{
	channel = "dummy";
	QString filename = saveZipFile(channel, source); // file will nl saved as dummy--currentDate--.xml

	// this method will split the huge single xml file per channel
	// be patient this takes time
	splitXMLTVFile(filename);

	return filename;
}

void NLFiles::setInput(DownloadInput d)
{
	DataDownloader::setInput(d);
}

void NLFiles::sendRecordMsg(QStringList data)
{
}

void NLFiles::sentRecordMsg(int exitCode, QProcess::ExitStatus exitStatus)
{
}
