#include <QtGui/QMainWindow>
#include <QPushButton>
#include <QRadioButton>
#include <QGridLayout>
#include <QGroupBox>
#include <QHBoxLayout>
#include <QLabel>
#include <QMaemo5ValueButton>
#include <QMaemo5TimePickSelector>
#include <QDebug>

#include "settings.h" 
#include "misc.h" 

MiscSettingsWindow::MiscSettingsWindow(QMainWindow* parent) : SettingsWindow(parent),ICONPATH("/opt/showtime/icons/")
{
	setWindowTitle("MISC SETTINGS");

	loadSettings();
	
	QWidget *_mainwidget = new QWidget;
	QTabWidget	*_tabwidget = new QTabWidget;
	QWidget *_miscwidget = new QWidget;
	QWidget *_timewidget = new QWidget;
	QWidget *_iconwidget = new QWidget;
	_tabwidget->addTab(_miscwidget, QString("     MISC     "));
	_tabwidget->addTab(_timewidget, QString("     TIME     "));
	_tabwidget->addTab(_iconwidget, QString("     ICON     "));

	QGroupBox *orientBox = new QGroupBox("Orientation");
	QGroupBox *remindBox = new QGroupBox("Remind Type");
	QGroupBox *showPastBox = new QGroupBox("Past Listings");
	QGroupBox *primeTimeBox = new QGroupBox("Prime Time");
	QGroupBox *iconBox = new QGroupBox("Icon Style");
	QGroupBox *previewBox = new QGroupBox("Icon Preview");

	QRadioButton *radio1 = new QRadioButton("Landscape");
	QRadioButton *radio2 = new QRadioButton("Portrait");
	QRadioButton *radio3 = new QRadioButton("Auto");
	QRadioButton *radio4 = new QRadioButton("Event");
	QRadioButton *radio5 = new QRadioButton("Alarm");
	QRadioButton *radio6 = new QRadioButton("Show");
	QRadioButton *radio7 = new QRadioButton("Hide");
	QRadioButton *radio8 = new QRadioButton("Set1");
	QRadioButton *radio9 = new QRadioButton("Set2");
	QRadioButton *radio10 = new QRadioButton("Set3");
	QRadioButton *radio11 = new QRadioButton("Set4");

	QVBoxLayout *box1 = new QVBoxLayout;
	QVBoxLayout *box2 = new QVBoxLayout;
	QVBoxLayout *box3 = new QVBoxLayout;
	QVBoxLayout *box4 = new QVBoxLayout;
	QHBoxLayout *box5 = new QHBoxLayout;
	QHBoxLayout *box6 = new QHBoxLayout;

	box1->addWidget(radio1);
	box1->addWidget(radio2);
	box1->addWidget(radio3);
	orientBox->setLayout(box1);

	box2->addWidget(radio4);
	box2->addWidget(radio5);
	remindBox->setLayout(box2);

	box3->addWidget(radio6);
	box3->addWidget(radio7);
	showPastBox->setLayout(box3);

	startTimeSelector = new QMaemo5ValueButton("start time");
	endTimeSelector = new QMaemo5ValueButton("start time");
	startTimeSelector->setPickSelector(new QMaemo5TimePickSelector());
	endTimeSelector->setPickSelector(new QMaemo5TimePickSelector());
	startTimeSelector->setValueText(getPrimeTimeStart());
	endTimeSelector->setValueText(getPrimeTimeEnd());
	box4->addWidget(startTimeSelector);
	box4->addWidget(endTimeSelector);
	primeTimeBox->setLayout(box4);

	box5->addWidget(radio8);
	box5->addWidget(radio9);
	box5->addWidget(radio10);
	box5->addWidget(radio11);
	iconBox->setLayout(box5);

	preview1 = new QLabel;
	preview2 = new QLabel;
	preview3 = new QLabel;
	preview4 = new QLabel;
	box6->addWidget(preview1);
	box6->addWidget(preview2);
	box6->addWidget(preview3);
	box6->addWidget(preview4);
	previewBox->setLayout(box6);

	QPushButton *cancelButton = new QPushButton("CANCEL");
	QPushButton *saveButton = new QPushButton("SAVE");

	QGridLayout *grid1 = new QGridLayout;
	QGridLayout *grid2 = new QGridLayout;
	QGridLayout *grid3 = new QGridLayout;
	grid1->addWidget(orientBox, 0, 0);
	grid1->addWidget(remindBox, 0, 1);
	grid2->addWidget(showPastBox, 0, 0);
	grid2->addWidget(primeTimeBox, 0, 1);
	grid3->addWidget(iconBox, 0, 0);
	grid3->addWidget(previewBox, 1, 0);

	_miscwidget->setLayout(grid1);
	_timewidget->setLayout(grid2);
	_iconwidget->setLayout(grid3);

	QVBoxLayout *vlayout = new QVBoxLayout;
	QHBoxLayout *hlayout = new QHBoxLayout;
	hlayout->addWidget(cancelButton);
	hlayout->addWidget(saveButton);
	vlayout->addWidget(_tabwidget);
	vlayout->addLayout(hlayout);
	_mainwidget->setLayout(vlayout);
	setCentralWidget(_mainwidget);

	connect(radio1, SIGNAL(clicked()), this, SLOT(setLandscape()));
	connect(radio2, SIGNAL(clicked()), this, SLOT(setPortrait()));
	connect(radio3, SIGNAL(clicked()), this, SLOT(setAuto()));
	connect(radio4, SIGNAL(clicked()), this, SLOT(setEventOnly()));
	connect(radio5, SIGNAL(clicked()), this, SLOT(setEventAndAlarm()));
	connect(radio6, SIGNAL(clicked()), this, SLOT(setShowPast()));
	connect(radio7, SIGNAL(clicked()), this, SLOT(setHidePast()));
	connect(radio8, SIGNAL(clicked()), this, SLOT(setIconSet1()));
	connect(radio9, SIGNAL(clicked()), this, SLOT(setIconSet2()));
	connect(radio10, SIGNAL(clicked()), this, SLOT(setIconSet3()));
	connect(radio11, SIGNAL(clicked()), this, SLOT(setIconSet4()));
	connect(startTimeSelector, SIGNAL(clicked()), this, SLOT(setStartPrimeTime()));
	connect(endTimeSelector, SIGNAL(clicked()), this, SLOT(setEndPrimeTime()));
	connect(cancelButton, SIGNAL(clicked()), this, SLOT(cancel()));
	connect(saveButton, SIGNAL(clicked()), this, SLOT(save()));

	// set the existing values
	if(getOrientation() == "PORTRAIT") radio2->setChecked(true);
	else if(getOrientation() == "AUTO") radio3->setChecked(true);
	else 
	{
		radio1->setChecked(true);  // default is landscape
		setOrientation("LANDSCAPE");
	}

	if(getRemindType() == "EVENT") radio4->setChecked(true);
	else 
	{
		radio5->setChecked(true);  // default is alarm
		setRemindType("ALARM");
	}

	if(getShowPastInd() == "N") 
	{
		radio7->setChecked(true);
	}
	else
	{
		radio6->setChecked(true);
		setShowPast();  // default is to show past programmes also
	}

	if(getIconType() == "SET2") 
	{
		setIconSet2();
		radio9->setChecked(true);
	}
	else if(getIconType() == "SET3") 
	{
		setIconSet3();
		radio10->setChecked(true);
	}
	else if(getIconType() == "SET4") 
	{
		setIconSet4();
		radio11->setChecked(true);
	}
	else 
	{
		setIconSet1();
		radio8->setChecked(true);  // default is set1
	}
}

void MiscSettingsWindow::setLandscape() { setOrientation("LANDSCAPE"); }
void MiscSettingsWindow::setPortrait() { setOrientation("PORTRAIT"); }
void MiscSettingsWindow::setAuto() { setOrientation("AUTO"); }
void MiscSettingsWindow::setEventOnly() { setRemindType("EVENT"); }
void MiscSettingsWindow::setEventAndAlarm() { setRemindType("ALARM"); }
void MiscSettingsWindow::setShowPast() { setShowPastInd("Y"); }
void MiscSettingsWindow::setHidePast() { setShowPastInd("N"); }
void MiscSettingsWindow::setStartPrimeTime() { setPrimeTimeStart(startTimeSelector->valueText()); }
void MiscSettingsWindow::setEndPrimeTime() { setPrimeTimeEnd(endTimeSelector->valueText()); }
void MiscSettingsWindow::setIconSet1() { setIconSet("SET1"); }
void MiscSettingsWindow::setIconSet2() { setIconSet("SET2"); }
void MiscSettingsWindow::setIconSet3() { setIconSet("SET3"); }
void MiscSettingsWindow::setIconSet4() { setIconSet("SET4"); }

void MiscSettingsWindow::setIconSet(QString iconset) 
{ 
	SettingsWindow::setIconType(iconset); 
	preview1->setPixmap(QString(ICONPATH)+iconset+"/"+"go.png"); 
	preview2->setPixmap(QString(ICONPATH)+iconset+"/"+"remind.png"); 
	preview3->setPixmap(QString(ICONPATH)+iconset+"/"+"record.png"); 
	preview4->setPixmap(QString(ICONPATH)+iconset+"/"+"search.png"); 
}

void MiscSettingsWindow::cancel() { emit clicked(); }
void MiscSettingsWindow::save() { updateSettings(); emit clicked(); }

MiscSettingsWindow::~MiscSettingsWindow() { }
