#include <QObject>
#include <QMaemo5InformationBox>
#include <QFile>
#include <QDir>
#include <QDebug>
#include <QProcess>
#include <QTextStream>

#include "datadownloader.h"
#include "sefiles.h"

SEFiles::SEFiles(QObject *parent) : DataDownloader(parent, "/opt/showtime/data/se/"), HELPERPATH("/opt/showtime/helper/")
{
	_settingsFile = new QFile(QString(DATAPATH) + ".se");
	initSettings();
}

void SEFiles::initSettings()
{
	// just call the parent init settings
	// nothing specific to se
	DataDownloader::initSettings();
}

QUrl SEFiles::getUrl()
{
	QUrl url;

	QString requestChannelCode = _channelCodeMap[_requestChannel];

	if ( !_useLocal )
		url.setUrl(QString("http://xmltv.tvsajten.com/xmltv/%1_%2.xml.gz?APP=SHOWTIME")
                                                            .arg(requestChannelCode).arg(_requestDate.toString("yyyy-MM-dd")) );
	else
		url.setPath(QString(""));

	return url;
}

SEFiles::~SEFiles()
{
}

// better to call this after we process all channels requested so we dont 
// have to do file operatings after each channel download
void SEFiles::updateSettingsFile()
{
	QFile::remove(QString(DATAPATH) + ".se");

	_settingsFile->open(QIODevice::WriteOnly | QIODevice::ReadOnly);

	QTextStream s(_settingsFile);

	foreach(QString key, _channelDateMap.keys())	
	{
		s << "#" << key;
		foreach(QString date, _channelDateMap[key])
			s << '#' << date; 

		s << endl;
	}

	_settingsFile->close();
}

void SEFiles::checkDataStatus()
{
	// IF ( data is requested again on the same day  OR  data is requested for download on the same day again )
	// THEN dont do anything and use local file
	if ( _channelDateMap[_requestChannel].contains(_requestDate.toString("ddMMyyyy")) )
	{
		// file exists for today ( current date ) so no need to download again
		//qDebug() << "data for " << _requestChannel << " for date " << _requestDate << " exists";
		_useLocal = true;
	}
	else
	{
		// download the requested channel for the requested date
		_useLocal = false;
	}
}

QString SEFiles::finishedDownload(QString channel, QIODevice *source)
{
	QString filename = saveFile(channel, source);
	return filename;
}

QStringList SEFiles::getChannelList()
{
	QFile file(QString(DATAPATH) + ".se_channel_list");
	QStringList channellist;

	if (file.open(QIODevice::ReadOnly | QIODevice::Text))
	{
		QTextStream textStream(&file);
		
		while ( !textStream.atEnd() )
		{
			QStringList line = textStream.readLine().split('#');
			
			QString channelname = line[0];
			QString channelcode = line[1];

			_channelCodeMap[channelname] = channelcode;
		}

		return _channelCodeMap.keys();
	}
	
	return channellist;
}

void SEFiles::setInput(DownloadInput d)
{
	DataDownloader::setInput(d);
}

void SEFiles::sendRecordMsg(QStringList data)
{
}

void SEFiles::sentRecordMsg(int exitCode, QProcess::ExitStatus exitStatus)
{

}
