#include <QObject>
#include <QMaemo5InformationBox>
#include <QFile>
#include <QDir>
#include <QDebug>
#include <QProcess>
#include <QTextStream>

#include "datadownloader.h"
#include "hrfiles.h"

HRFiles::HRFiles(QObject *parent) : DataDownloader(parent, "/opt/showtime/data/hr/"), HELPERPATH("/opt/showtime/helper/")
{
	_settingsFile = new QFile(QString(DATAPATH) + ".hr");
	initSettings();
}

void HRFiles::initSettings()
{
	// just call the parent init settings
	// nothing specific to HR(germany)
	DataDownloader::initSettings();
}

QUrl HRFiles::getUrl()
{
	QUrl url;

	QString requestChannelCode = _channelCodeMap[_requestChannel];

	if ( !_useLocal )
		url.setUrl(QString("http://tvprofil.net/xmltv/data/%2/%1_%2_tvprofil.net.xml?APP=SHOWTIME")
                                                            .arg(_requestDate.toString("yyyy-MM-dd")).arg(requestChannelCode) );
	else
		url.setPath(QString(""));

	return url;
}

HRFiles::~HRFiles()
{
}

// better to call this after we process all channels requested so we dont 
// have to do file operatings after each channel download
void HRFiles::updateSettingsFile()
{
	QFile::remove(QString(DATAPATH) + ".hr");

	_settingsFile->open(QIODevice::WriteOnly | QIODevice::ReadOnly);

	QTextStream s(_settingsFile);

	foreach(QString key, _channelDateMap.keys())	
	{
		s << "#" << key;
		foreach(QString date, _channelDateMap[key])
			s << '#' << date; 

		s << endl;
	}

	_settingsFile->close();
}

void HRFiles::checkDataStatus()
{
	// IF ( data is requested again on the same day  OR  data is requested for download on the same day again )
	// THEN dont do anything and use local file
	if ( _channelDateMap[_requestChannel].contains(_requestDate.toString("ddMMyyyy")) )
	{
		// file exists for today ( current date ) so no need to download again
		//qDebug() << "data for " << _requestChannel << " for date " << _requestDate << " exists";
		_useLocal = true;
	}
	else
	{
		// download the requested channel for the requested date
		_useLocal = false;
	}
}

QString HRFiles::finishedDownload(QString channel, QIODevice *source)
{
	QString filename = saveFile(channel, source);
	return filename;
}

QStringList HRFiles::getChannelList()
{
	QFile file(QString(DATAPATH) + ".hr_channel_list");
	QStringList channellist;

	if (file.open(QIODevice::ReadOnly | QIODevice::Text))
	{
		QTextStream textStream(&file);
		
		while ( !textStream.atEnd() )
		{
			QStringList line = textStream.readLine().split('#');
			
			QString channelname = line[0];
			QString channelcode = line[1];

			_channelCodeMap[channelname] = channelcode;
		}

		return _channelCodeMap.keys();
	}
	
	return channellist;
}

void HRFiles::setInput(DownloadInput d)
{
	DataDownloader::setInput(d);
}

void HRFiles::sendRecordMsg(QStringList data)
{
}

void HRFiles::sentRecordMsg(int exitCode, QProcess::ExitStatus exitStatus)
{
}
