#ifndef SETTINGSWINDOW_H
#define SETTINGSWINDOW_H

#include <QtGui/QMainWindow>
#include <QPushButton>
#include <QToolButton>
#include <QHBoxLayout>
#include <QMap>

class QWidget;

class SettingsWindow : public QMainWindow 
{
    Q_OBJECT

public:
    SettingsWindow(QMainWindow* parent); 

	~SettingsWindow();

	QString getRegion();
	QString getRemindType();
	QString getOrientation();
	QString getIconType();
	const QStringList getFavourites(QString region) const;
	QStringList getFavourites(QString region);
	const QString getIconPath();
	const QString getBinPath();
	QMap<QString, QStringList>& getSettingsMap();
	void removeFromFavourite(QString region, QString channel);

	void setRegion(QString region);
	void setRemindType(QString remindType);
	void setOrientation(QString orientation);
	void setIconType(QString iconset);
	void setFavourites(QString region, QString channel);

	void loadSettings();
	void updateSettings();

public slots:

private slots:

protected: // functions

protected:
	QMap<QString, QStringList> _settingsMap;

private:
	const char* BINPATH;
	const char* ICONPATH;
};

#endif // SETTINGSWINDOW_H
