#include "reminder.h"

#include <CCalendar.h>
#include <CMulticalendar.h>
#include <CTodo.h>
#include <CBdayEvent.h>
#include <CEvent.h>
#include <CAlarm.h>

static const int DAY_IN_SECONDS = 86400;

Reminder::Reminder()
{    
    multiCalendar = CMulticalendar::MCInstance();
}

Reminder::~Reminder()
{
    delete multiCalendar;
}

bool Reminder::addCalendar(const QString& calendarName)
{
    CalendarType type = (CalendarType) 0;
    int errorCode = 0 /*FAILURE = 0*/;

    multiCalendar->addCalendar (calendarName.toStdString(), COLOUR_YELLOW,
        0, 1, type /*Local calendar*/,
        "Default" /*CalendarTune*/,
        "0.1" /*CalendarVersion*/, errorCode);
    return (errorCode);
}

bool Reminder::removeCalendar(const QString& calendarName)
{
    int errorCode = 0;
    bool success = false;
    CCalendar *calendar = multiCalendar->getCalendarByName (calendarName.toStdString(), errorCode);
    if (errorCode)
    {
        success = multiCalendar->deleteCalendar (calendar->getCalendarId(), errorCode);
    }
    delete calendar;
    return success;
}

void Reminder::addEvent(const QString& calendarName, const QDateTime& sdate, const QDateTime& edate,
    const QString& eventName, const QString& description,
    int type)
{
    int errorCode = 0;
    int sdateUtc = sdate.toTime_t();
    int edateUtc = edate.toTime_t();

    CCalendar *calendar = multiCalendar->getCalendarByName (calendarName.toStdString(), errorCode);
    switch (type)
    {
        case 1:
        {    
            CEvent *pEvent = new CEvent(eventName.toStdString(), description.toStdString(), "", sdateUtc, edateUtc);
			calendar->setNextAlarm(pEvent->getId(), 1, type);
            multiCalendar->addEvent(pEvent, calendar->getCalendarId(), errorCode);
            delete pEvent;
        }
        break;

        case 2:
        {    
            CTodo *pTodo = new CTodo(eventName.toStdString(), sdateUtc, ACCEPTED_STATUS);
            multiCalendar->addTodo(pTodo, calendar->getCalendarId(), errorCode);
            delete pTodo;
        }
        break;
    }
    delete calendar;
}

bool Reminder::checkCalendarNameExists(const QString& calendarName)
{
	return multiCalendar->checkCalendarNameExists(calendarName.toStdString());
}

void Reminder::addAlarmEvent(const QString& calendarName, const QDateTime& event_time, const QString& title, const QDateTime& dateStart,
									const QDateTime& dateEnd, const QString& description)
{
	int errorCode = 0;
	int sdateUtc = dateStart.toTime_t();
	int edateUtc = dateEnd.toTime_t();

	CCalendar *calendar = multiCalendar->getCalendarByName (calendarName.toStdString(), errorCode);
	CEvent *pEvent = new CEvent(title.toStdString(), description.toStdString(), "", sdateUtc, edateUtc);
	CAlarm *alarmEvent = new CAlarm();
	alarmEvent->setDuration(E_AM_15MIN);
	alarmEvent->setTrigger(sdateUtc - 15 * 60);

	pEvent->setAlarm(alarmEvent);
    multiCalendar->addEvent(pEvent, calendar->getCalendarId(), errorCode);

	//alarmEvent->addAlarmEvent(sdateUtc, title.toStdString(), "", sdateUtc, edateUtc, pEvent->getId(), calendar->getCalendarId(),
	//													description.toStdString(), 1, false, "", errorCode );

	delete pEvent;
	delete alarmEvent;
	delete calendar;
}
