#include <QToolButton>
#include <QListWidget>
#include <QHBoxLayout>
#include <QVBoxLayout>
#include <QDebug>

#include "infoaccess.h"
#include "settings.h"
#include "region.h"

RegionWindow::RegionWindow(QMainWindow *parent) : SettingsWindow(parent), FLAGPATH("/opt/showtime/flags/")
{
	setWindowTitle("SELECT REGION");
	QWidget *widget = new QWidget(this);
	
	MyToolButton *ukButton = new MyToolButton(QIcon(QString(FLAGPATH) + "uk.png"), "UK", this);
	MyToolButton *auButton = new MyToolButton(QIcon(QString(FLAGPATH) + "au.png"), "AU", this);
	MyToolButton *nzButton = new MyToolButton(QIcon(QString(FLAGPATH) + "nz.png"), "NZ", this);
	MyToolButton *seButton = new MyToolButton(QIcon(QString(FLAGPATH) + "se.png"), "SE", this);
	MyToolButton *deButton = new MyToolButton(QIcon(QString(FLAGPATH) + "de.png"), "DE", this);
	MyToolButton *esButton = new MyToolButton(QIcon(QString(FLAGPATH) + "es.png"), "ES", this);
	MyToolButton *itButton = new MyToolButton(QIcon(QString(FLAGPATH) + "it.png"), "IT", this);
	MyToolButton *hrButton = new MyToolButton(QIcon(QString(FLAGPATH) + "hr.png"), "HR", this);
	MyToolButton *siButton = new MyToolButton(QIcon(QString(FLAGPATH) + "si.png"), "SI", this);
	
	QHBoxLayout *layout1 = new QHBoxLayout;
	QHBoxLayout *layout2 = new QHBoxLayout;
	QHBoxLayout *layout3 = new QHBoxLayout;
	QVBoxLayout *layout4 = new QVBoxLayout;

	layout1->addWidget(ukButton);
	layout1->addWidget(auButton);
	layout1->addWidget(nzButton);
	layout2->addWidget(seButton);
	layout2->addWidget(deButton);
	layout2->addWidget(esButton);
	layout3->addWidget(itButton);
	layout3->addWidget(hrButton);
	layout3->addWidget(siButton);

	layout4->addLayout(layout1);
	layout4->addLayout(layout2);
	layout4->addLayout(layout3);
	
	widget->setLayout(layout4);
	
	setCentralWidget(widget);
	
	connect(ukButton, SIGNAL(clicked()), this, SLOT(setUK()));
	connect(auButton, SIGNAL(clicked()), this, SLOT(setAU()));
	connect(nzButton, SIGNAL(clicked()), this, SLOT(setNZ()));
	connect(seButton, SIGNAL(clicked()), this, SLOT(setSE()));
	connect(deButton, SIGNAL(clicked()), this, SLOT(setDE()));
	connect(esButton, SIGNAL(clicked()), this, SLOT(setES()));
	connect(itButton, SIGNAL(clicked()), this, SLOT(setIT()));
	connect(hrButton, SIGNAL(clicked()), this, SLOT(setHR()));
	connect(siButton, SIGNAL(clicked()), this, SLOT(setSI()));
	
	loadSettings();
	}

void RegionWindow::setRegion(QString region)
{
	SettingsWindow::setRegion(region);
	updateSettings();
	emit clicked();
}

void RegionWindow::setUK()
{
	setRegion("UK");
}
void RegionWindow::setAU()
{
    setRegion("AU");
}
void RegionWindow::setNZ()
{
    setRegion("NZ");
}
void RegionWindow::setSE()
{
    setRegion("SE");
}
void RegionWindow::setDE()
{
    setRegion("DE");
}
void RegionWindow::setES()
{
    setRegion("ES");
}
void RegionWindow::setIT()
{
    setRegion("IT");
}
void RegionWindow::setHR()
{
    setRegion("HR");
}
void RegionWindow::setSI()
{
    setRegion("SI");
}

RegionWindow::~RegionWindow()
{
}
