#include <QObject>
#include <QMaemo5InformationBox>
#include <QFile>
#include <QDir>
#include <QDebug>
#include <QProcess>
#include <QTextStream>

#include "datadownloader.h"
#include "aufiles.h"

AUFiles::AUFiles(QObject *parent) : DataDownloader(parent, "/opt/showtime/data/au/"), HELPERPATH("/opt/showtime/data/helper/")
{
	_settingsFile = new QFile(QString(DATAPATH) + ".au");
	initSettings();
}

void AUFiles::initSettings()
{
	// just call the parent init settings
	// nothing specific to uk
	DataDownloader::initSettings();
}

QUrl AUFiles::getUrl()
{
	QUrl url;
	if ( !_useLocal )
		url.setUrl(QString("http://xml.oztivo.net/xmltv/%1_%2.xml.gz?APP=SHOWTIME").arg(_requestChannel).arg(_requestDate.toString("yyyy-MM-dd")) );
	else
		url.setPath(QString(""));

	return url;
}

AUFiles::~AUFiles()
{
}

// better to call this after we process all channels requested so we dont 
// have to do file operatings after each channel download
void AUFiles::updateSettingsFile()
{
	QFile::remove(QString(DATAPATH) + ".au");

	_settingsFile->open(QIODevice::WriteOnly | QIODevice::ReadOnly);

	QTextStream s(_settingsFile);

	foreach(QString key, _channelDateMap.keys())	
	{
		s << "#" << key;
		foreach(QString date, _channelDateMap[key])
			s << "#" << date;
			
		s << endl;
	}

	_settingsFile->close();
}

void AUFiles::checkDataStatus()
{
	// IF ( data is requested again on the same day  OR  data is requested for download on the same day again )
	// THEN dont do anything and use local file
	if ( _channelDateMap[_requestChannel].contains(_requestDate.toString("ddMMyyyy")) )
	{
		// file exists for today ( current date ) so no need to download again
		//qDebug() << "data for " << _requestChannel << " for date " << _requestDate << " exists";
		_useLocal = true;
	}
	else
	{
		// download the requested channel for the requested date
		_useLocal = false;
	}
}

QString AUFiles::finishedDownload(QString channel, QIODevice *source)
{
	QString filename = saveFile(channel, source);
	return filename;
}

QStringList AUFiles::getChannelList()
{
	QFile file(QString(DATAPATH) + ".au_channel_list");
	QStringList channellist;

	if (file.open(QIODevice::ReadOnly | QIODevice::Text))
	{
		QTextStream textStream(&file);
		
		while ( !textStream.atEnd() )
		{
			QString line = textStream.readLine();
			channellist << line;
		}
	}
	
	return channellist;
}

void AUFiles::setInput(DownloadInput d)
{
	DataDownloader::setInput(d);
}

void AUFiles::sendRecordMsg(QStringList data)
{
}

void AUFiles::sentRecordMsg(int exitCode, QProcess::ExitStatus exitStatus)
{

}
