#ifndef FAVOURITEWINDOW_H
#define FAVOURITEWINDOW_H

#include <QtGui/QMainWindow>
#include <QMap>

#include "settings.h"

class QWidget;
class QMaemo5ValueButton;
class QMaemo5ListPickSelector;
class QStandardItemModel;
class QHBoxLayout;
class QVBoxLayout;
class QListWidget;
class QListWidgetItem;
class InfoAccess;
class QPushButton;


class FavouriteWindow : public SettingsWindow 
{
    Q_OBJECT

public:
    FavouriteWindow(QMainWindow* parent);

    ~FavouriteWindow();

public slots:

signals:
	void clicked();

private slots:
	void selectRegion(QString region);
	void selectChannel(QString channel);
	void removeChannel(QListWidgetItem *item);
	void doSave();
	void doCancel();

private: // functions
	void initRegionListModel();
	void initChannelListModel();
	void showSelectedListWidget();

private:
	QMaemo5ValueButton *_regionSelector;
	QMaemo5ListPickSelector	*_regionSelectorList;
	QStandardItemModel *_regionListModel;
	QMaemo5ValueButton *_channelSelector;
	QMaemo5ListPickSelector	*_channelSelectorList;
	QStandardItemModel *_channelListModel;

	QPushButton *_cancelButton;
	QPushButton *_saveButton;

	QHBoxLayout	*_h1layout;
	QHBoxLayout	*_h2layout;
	QHBoxLayout	*_h3layout;
	QVBoxLayout	*_v1layout;
	QWidget	*_mainwidget;

	QListWidget	*_selectedListWidget;

	InfoAccess *_infoapi;

	QString _region;
};

#endif // FAVOURITEWINDOW_H
