#include <QObject>
#include <QFile>
#include <QDir>
#include <QMaemo5InformationBox>
#include <QTextStream>
#include <QProcess>
#include <QDebug>

#include "datadownloader.h"

DataDownloader::DataDownloader(QObject *parent) : QObject(parent)
{
}

DataDownloader::DataDownloader(QObject *parent, const char* datapath) : QObject(parent), DATAPATH(datapath)
{
}

void DataDownloader::initSettings()
{
	_settingsFile->open(QIODevice::WriteOnly | QIODevice::ReadOnly);

	QTextStream stream(_settingsFile);

	// create the map of channel and date until which data is available
	while ( !stream.atEnd() )
	{
		QString line = stream.readLine();

		QString channel = line.section('#',1,1);	
		// dates are in this format ==>  #bbc1#01022010#02022010#05022010
		QStringList datelist = line.section('#',2).split('#');	

		_channelDateMap[channel] = datelist;
	}

	_settingsFile->close();
}

QString DataDownloader::finishedDownload(QString channel, QIODevice *source)
{
	return (QString());
}

QString DataDownloader::saveFile(QString channel, QIODevice *source)
{
	//qDebug() << "File has been downloaded for : " << channel;
	// update the channel data map now that the data file has been successfully downloaded
	_channelDateMap[_requestChannel].append(_requestDate.toString("ddMMyyyy"));

	QString filename = QString(QString(DATAPATH) + "%1--%2--.xml").arg(_requestChannel).arg(_requestDate.toString("ddMMyyyy"));
	QFile xmlFile(filename);
	xmlFile.open(QIODevice::WriteOnly);

	xmlFile.write(source->readAll());
	xmlFile.close();

	return filename;
}

QString DataDownloader::saveZipFile(QString channel, QIODevice *source)
{
	//qDebug() << "File has been downloaded for : " << channel;
	// update the channel data map now that the data file has been successfully downloaded
	_channelDateMap[_requestChannel].append(_requestDate.toString("ddMMyyyy"));

	QFile::remove(QString(QString(DATAPATH) + "%1--%2--.xml.gz").arg(_requestChannel).arg(_requestDate.toString("ddMMyyyy")));
	QFile::remove(QString(QString(DATAPATH) + "%1--%2--.xml").arg(_requestChannel).arg(_requestDate.toString("ddMMyyyy")));

	QString zipfile = QString(QString(DATAPATH) + "%1--%2--.xml.gz").arg(channel).arg(_requestDate.toString("ddMMyyyy"));
	QString filename = QString(QString(DATAPATH) + "%1--%2--.xml").arg(channel).arg(_requestDate.toString("ddMMyyyy"));

	QFile gzipFile(zipfile);
	gzipFile.open(QIODevice::WriteOnly);

	gzipFile.write(source->readAll());
	gzipFile.close();

	QProcess gzip;
	QString cmd("gzip -f -d " + gzipFile.fileName());

	gzip.start(cmd);
	gzip.waitForFinished();

	return filename;
}

DataDownloader::~DataDownloader()
{
}

QStringList DataDownloader::getFilelist(QString channel)
{
	QDir xmltvPath(QString(DATAPATH), channel + "-*.xml");
	QStringList filelist( xmltvPath.entryList());

	QStringList fullPathFileList;
	
	foreach(QString filename , filelist)
		fullPathFileList << QString(DATAPATH)+filename;

	//qDebug() << fullPathFileList;

	return fullPathFileList;
}

void DataDownloader::setInput(DownloadInput d)
{
	_downloadIndicator = d.downloadIndicator;
	_requestChannel = d.requestChannel;
	_requestDate = d.requestDate;
}
