#ifndef REGIONWINDOW_H
#define REGIONWINDOW_H

#include <QtGui/QMainWindow>
#include <QPushButton>
#include <QToolButton>
#include <QHBoxLayout>

#include "settings.h"

class QWidget;

class MyToolButton : public QToolButton
{
public:
	MyToolButton(QIcon icon, QString text, QMainWindow *parent) : QToolButton(parent)
	{
		setToolButtonStyle(Qt::ToolButtonTextUnderIcon);
		setIcon(icon);
		setText(text);
		setAutoRaise(true);
	}

	~MyToolButton() { };
};

class RegionWindow : public SettingsWindow 
{
    Q_OBJECT

public:
    RegionWindow(QMainWindow* parent); 

    ~RegionWindow();

	QStringList getRegionList()
	{
		QStringList list;
		list << "UK" << "AU" << "NZ" << "SE" << "DE" << "ES" << "IT" << "HR" << "SI";
		return list;
	}

public slots:

private slots:
	void setUK();
	void setAU();
	void setNZ();
	void setSE();
	void setDE();
	void setES();
	void setIT();
	void setHR();
	void setSI();
	void setRegion(QString region);

signals:
	void clicked();

private: // functions

private:
	const char *FLAGPATH;
};

#endif // REGIONWINDOW_H
