#include <QObject>
#include <QMaemo5InformationBox>
#include <QFile>
#include <QDir>
#include <QDebug>
#include <QProcess>
#include <QTextStream>

#include "datadownloader.h"
#include "nzfiles.h"

NZFiles::NZFiles(QObject *parent) : DataDownloader(parent, "/opt/showtime/data/nz/"), HELPERPATH("/opt/showtime/helper/")
{
	_settingsFile = new QFile(QString(DATAPATH) + ".nz");
	initSettings();
}

void NZFiles::initSettings()
{
	// just call the parent init settings
	// nothing specific to nz
	DataDownloader::initSettings();
}

QUrl NZFiles::getUrl()
{
	QUrl url;

	QString requestChannelCode = _channelCodeMap[_requestChannel];

	if ( !_useLocal )
		url.setUrl(QString("http://download.xmltv.co.nz/?provider=telstra&channels=%1&days=%2&APP=SHOWTIME").arg(requestChannelCode).arg(_downloadStartIndex) );
	else
		url.setPath(QString(""));

	return url;
}

NZFiles::~NZFiles()
{
}

void NZFiles::prepareUrl()
{
	_downloadStartIndex = QDate::currentDate().daysTo(_requestDate);
	// if the time of day in NZ is between 0 and 7am then get the next index as data is generated only at 6am in the morning
	if ( QTime::currentTime().hour() >= 0 && QTime::currentTime().hour() <= 7 )
		_downloadStartIndex++;
}

// better to call this after we process all channels requested so we dont 
// have to do file operatings after each channel download
void NZFiles::updateSettingsFile()
{
	QFile::remove(QString(DATAPATH) + ".nz");

	_settingsFile->open(QIODevice::WriteOnly | QIODevice::ReadOnly);

	QTextStream s(_settingsFile);

	foreach(QString key, _channelDateMap.keys())	
	{
		s << "#" << key;
		foreach(QString date, _channelDateMap[key])
			s << '#' << date; 

		s << endl;
	}

	_settingsFile->close();
}

void NZFiles::checkDataStatus()
{
	// IF ( data is requested again on the same day  OR  data is requested for download on the same day again )
	// THEN dont do anything and use local file
	if ( _channelDateMap[_requestChannel].contains(_requestDate.toString("ddMMyyyy")) )
	{
		// file exists for today ( current date ) so no need to download again
		//qDebug() << "data for " << _requestChannel << " for date " << _requestDate << " exists";
		_useLocal = true;
	}
	else
	{
		// download the requested channel for the requested date
		_useLocal = false;
		prepareUrl();
	}
}

QString NZFiles::finishedDownload(QString channel, QIODevice *source)
{
	QString filename = saveFile(channel, source);
	return filename;
}

QStringList NZFiles::getChannelList()
{
	QFile file(QString(DATAPATH) + ".nz_channel_list");
	QStringList channellist;

	if (file.open(QIODevice::ReadOnly | QIODevice::Text))
	{
		QTextStream textStream(&file);
		
		while ( !textStream.atEnd() )
		{
			QStringList line = textStream.readLine().split('#');
			
			QString channelname = line[0];
			QString channelcode = line[1];

			_channelCodeMap[channelname] = channelcode;
		}

		return _channelCodeMap.keys();
	}
	
	return channellist;
}

void NZFiles::setInput(DownloadInput d)
{
	DataDownloader::setInput(d);
}

void NZFiles::sendRecordMsg(QStringList data)
{
}

void NZFiles::sentRecordMsg(int exitCode, QProcess::ExitStatus exitStatus)
{

}
