#ifndef DEFILES_H
#define DEFILES_H

#include <QObject>
#include <QStringList>
#include <QSet>
#include <QUrl>
#include <QMap>
#include <QProcess>

class QIODevice;

#include "datadownloader.h"

class DEFiles : public DataDownloader
{
    Q_OBJECT

public:
    DEFiles( QObject *parent );
    virtual ~DEFiles();
	virtual QUrl getUrl();
	void initSettings();
	virtual void updateSettingsFile();
	virtual void checkDataStatus();
	virtual void setInput(DownloadInput d);
	virtual QString finishedDownload(QString channel, QIODevice *source);
	virtual QStringList getChannelList();
	void sendRecordMsg(QStringList data);

signals:

public slots:

private slots:
	void sentRecordMsg(int exitCode, QProcess::ExitStatus exitStatus);

protected:
	void updateDownloadIndexes();

private:
	const char* HELPERPATH;

	// DE channels names are different from the channel code we need during a network download request url
	// hence we maintain this mapping as the codes dont mean much to the user while displaying the list :)
	QMap<QString , QString> _channelCodeMap;
};

#endif // DEFILES_H
