#include <QtGui>
#include <iostream>
#include <stdlib.h>
#include "usermenu.h"


CUserMenu::CUserMenu()
{
	win = new QDialog();
	win->setWindowTitle("Shortcutd user menu");
	win->setAttribute(Qt::WA_Maemo5AutoOrientation, true);

	QVBoxLayout *vbox = new QVBoxLayout(win);

	int cmdcount = readSettings("/home/user/.shortcutd/usermenu.conf");
	if( cmdcount == 0 ) {
		QLabel *label = new QLabel(win);
		label->setWordWrap(true);
		label->setText("No menu items defined. Edit /home/user/.shortcutd/usermenu.conf");
		vbox->addWidget(label);
	} else if (cmdcount < 0) {
        QLabel *label = new QLabel(win);
        label->setWordWrap(true);
        label->setText("Error in config file. Edit /home/user/.shortcutd/usermenu.conf");
        vbox->addWidget(label);
	} else if (cmdcount > 0) {
		int c=0, r=0;
		QGridLayout *grid = new QGridLayout();
		vbox->addLayout(grid);
		for(int i=0; i<cmdcount; i++)
		{
			QPushButton *pb = new QPushButton();
			pb->setText(titles.at(i));
			QString s;
			s.setNum(i);
			pb->setObjectName(s);
			connect( pb, SIGNAL(clicked()), this, SLOT(action()) );
			grid->addWidget(pb,r,c);
			c++;
			if(c==3) {
				c=0;
				r++;
			}
		}
	}

	win->show();
}

CUserMenu::~CUserMenu()
{
	delete win;
}

int CUserMenu::readSettings(QString filename_)
{
	QFile file(filename_);
	if( !file.open(QIODevice::ReadOnly|QIODevice::Text) ) {
		return 0;
	}
	QTextStream in(&file);

	QString s = in.readLine();
	while (!s.isNull())
	{
		if( s.startsWith("title:") ) {
			titles.append(s.section(':',1));
		}
		if( s.startsWith("command:shell:") ) {
			commands.append(s);
		}
		if( s.startsWith("command:keypress:") ) {
			commands.append(s);
		}
		s = in.readLine();
	}

	file.close();

	if( titles.count() != commands.count() ) {
		titles.clear();
		commands.clear();
		return -1;
	}
	return titles.count();
}

void CUserMenu::action()
{
	if( !sender() ) return;

	int i = sender()->objectName().toInt();
	QString cmd = commands.at(i);

	if( cmd.startsWith("command:shell:") )
	{
		actionShellCommand(cmd.section(':',2));
	}
	if( cmd.startsWith("command:keypress:") )
	{
		
	}

	QApplication::exit(0);
}

int CUserMenu::actionShellCommand(QString cmd_)
{
	std::cout << ">>" << cmd_.toStdString() << "<<" << std::endl;
	if( !cmd_.endsWith('&') )
		cmd_+=" &>/dev/null &";
	return system(cmd_.toStdString().c_str());
}

void CUserMenu::actionKeypress(QList<int> keycodes_)
{
/*
	keycode = 37;
	is_down=1;

	XTestFakeKeyEvent(dpy, keycode, is_down, 0);
	XSync(dpy, 1);

	keycode = 22;
	is_down=1;

	XTestFakeKeyEvent(dpy, keycode, is_down, 0);
	XSync(dpy, 1);

	keycode = 22;
	is_down=0;

	XTestFakeKeyEvent(dpy, keycode, is_down, 0);
	XSync(dpy, 1);

	keycode = 37;
	is_down=0;

	XTestFakeKeyEvent(dpy, keycode, is_down, 0);
	XSync(dpy, 1);
*/
}

