#include "camkey.h"
#include "shortcutd.h"
#include <sys/time.h>
#include <unistd.h>
#include <signal.h>

DBusError CameraKey::dbus_err;
LibHalContext* CameraKey::halctx;
int CameraKey::shutter_state;
bool CameraKey::timeExpired;

CameraKey* CameraKey::me=NULL;

CameraKey::CameraKey(Launcher* launcher_):launcher(launcher_)
{
	shutter_state = 0;
	initSuccess = false;
	timeExpired = false;
	me=this;
}

CameraKey::~CameraKey()
{
    const char* hal_udi_camfocus = "/org/freedesktop/Hal/devices/platform_cam_focus";
    const char* hal_udi_shutter = "/org/freedesktop/Hal/devices/platform_cam_shutter";

	if( initSuccess )
	{
	    libhal_device_remove_property_watch(halctx, hal_udi_shutter, &dbus_err);
	    libhal_device_remove_property_watch(halctx, hal_udi_camfocus, &dbus_err);
	    libhal_ctx_shutdown(halctx, &dbus_err);
	    libhal_ctx_free(halctx);
	    dbus_connection_unref(dbus_sys);
	}
}

bool CameraKey::Init()
{
    const char* hal_udi_camfocus = "/org/freedesktop/Hal/devices/platform_cam_focus";
    const char* hal_udi_shutter = "/org/freedesktop/Hal/devices/platform_cam_shutter";

    
    halctx = libhal_ctx_new();
    dbus_sys = dbus_bus_get(DBUS_BUS_SYSTEM, &dbus_err);
        if ( dbus_error_is_set(&dbus_err) || dbus_sys==NULL ) {
        DebugPrint("ck init: system dbus init fail");
        return false;
    }
    //dbus_connection_setup_with_g_main(dbus_sys, NULL);
    if( !libhal_ctx_set_dbus_connection(halctx, dbus_sys) )
    {
        DebugPrint("ck init: hal dbus connection fail");
        return false;
    }
    if( !libhal_ctx_init(halctx, &dbus_err) )
    {
        DebugPrint("ck init: hal init fail");
        return false;
    }

    libhal_ctx_set_device_property_modified(halctx, CameraKey::PropertyModified);
    libhal_device_add_property_watch(halctx, hal_udi_shutter, &dbus_err);
    libhal_device_add_property_watch(halctx, hal_udi_camfocus, &dbus_err);

    shutter_state = libhal_device_get_property_bool(halctx, hal_udi_shutter,
        "button.state.value", &dbus_err);

	signal( SIGALRM, CameraKey::AlarmHandler );

	initSuccess = true;
	return true;
}

void CameraKey::PropertyModified( LibHalContext* ctx, const char* udi, const char* key,
                            dbus_bool_t is_removed, dbus_bool_t is_added)
{
	const char* hal_udi_camfocus = "/org/freedesktop/Hal/devices/platform_cam_focus";
	const char* hal_udi_shutter = "/org/freedesktop/Hal/devices/platform_cam_shutter";

    //printf("hal property callback %s: %s\n", udi, key);
    int state = libhal_device_get_property_bool(halctx, udi, "button.state.value", &dbus_err);

    if( strcmp(udi, hal_udi_shutter)==0 )
    {
		DebugPrint("cam shutter state change");
        shutter_state = state;
    }

    if( strcmp(udi, hal_udi_camfocus)==0 && shutter_state==1 && state==1 )
    {
		DebugPrint("cam focus button down");
		timeExpired = false;
		alarm(1);
    }

	if( strcmp(udi, hal_udi_camfocus)==0 && shutter_state==1 && state==0 )
	{
		DebugPrint("cam focus button up");
		if( timeExpired == false )
		{
			alarm(0); //cancel alarm signal
			DebugPrint("short press");
			me->doShortPress();
		}
	}

}

bool CameraKey::doShortPress()
{
	if (shortPress.compare("dashboard")==0)
		launcher->Dashboard();
	if (shortPress.compare("phone")==0)
		launcher->Phone();
	if (shortPress.compare("menu")==0)
		launcher->Menu();
    if (shortPress.compare("backspace")==0)
        launcher->Backspace();
    if (shortPress.compare("usermenu")==0)
        launcher->userMenu();
	if (shortPress.compare("shellcommand")==0)
		launcher->shellCommand();
	if (shortPress.compare("desktop")==0)
		launcher->switchToDesktop();
    if (shortPress.compare("textreflow")==0)
        launcher->TextReflow();
    if (shortPress.compare("rotation")==0)
        launcher->Rotation();

	return true;
}


bool CameraKey::doLongPress()
{
	if (longPress.compare("phone")==0)
		launcher->Phone();
	if (longPress.compare("dashboard")==0)
		launcher->Dashboard();
	if (longPress.compare("menu")==0)
		launcher->Menu();
	if (longPress.compare("backspace")==0)
		launcher->Backspace();
	if (longPress.compare("usermenu")==0)
		launcher->userMenu();
	if (longPress.compare("shellcommand")==0)
		launcher->shellCommand();
	if (longPress.compare("desktop")==0)
		launcher->switchToDesktop();
    if (longPress.compare("textreflow")==0)
        launcher->TextReflow();
    if (longPress.compare("rotation")==0)
        launcher->Rotation();


	return true;
}


DBusConnection* CameraKey::GetSysDBus()
{
	return dbus_sys;
}

void CameraKey::AlarmHandler(int sig)
{
	timeExpired = true;
	DebugPrint("long press");
	me->doLongPress();
}
