#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <glib.h>
#include "launcher.h"

Display* Launcher::stc_dpy;
Window Launcher::stc_win;
bool Launcher::stc_grab;
int Launcher::stc_pointer_oldx;
int Launcher::stc_pointer_oldy;


Launcher::Launcher()
{

	Init();


}

Launcher::~Launcher()
{



}


bool Launcher::Init()
{
	defaultShellCommand = "";

	DebugPrint("phone init");
	connectToDbusPhone();
	paramPhone="rtcom-call-ui";
	
	dpy = XOpenDisplay(getenv("DISPLAY"));
        
	if (!dpy)
	{
		DebugPrint("dpy null");
		exit(1);
	}
	
	scr = DefaultScreen(dpy);
	win = RootWindow(dpy, scr);
	XGetGeometry(dpy, win, &ret_win, &x, &y, &width, &height, &border_width, &depth);
	XSynchronize(dpy, True);
		
	stc_dpy = dpy;
	stc_win = win;
	stc_grab = FALSE;


return true;
}


bool Launcher::Dashboard()
{
	keycode = 37;
	is_down=1;

        XTestFakeKeyEvent(dpy, keycode, is_down, 0);
        XSync(dpy, 1);

        keycode = 22;
        is_down=1;

        XTestFakeKeyEvent(dpy, keycode, is_down, 0);
        XSync(dpy, 1);

        keycode = 22;
        is_down=0;

        XTestFakeKeyEvent(dpy, keycode, is_down, 0);
        XSync(dpy, 1);

        keycode = 37;
        is_down=0;

        XTestFakeKeyEvent(dpy, keycode, is_down, 0);
        XSync(dpy, 1);

        DebugPrint("DASH: launched");


	return true;
}


bool Launcher::Backspace()
{
	keycode = 22;
	is_down=1;

	XTestFakeKeyEvent(dpy, keycode, is_down, 0);
	XSync(dpy, 1);

	keycode = 22;
	is_down=0;

	XTestFakeKeyEvent(dpy, keycode, is_down, 0);
	XSync(dpy, 1);

	DebugPrint("backspace sent");

	return true;
}


bool Launcher::Rotation()
{
    keycode = 37;
    is_down=1;

    XTestFakeKeyEvent(dpy, keycode, is_down, 0);
    XSync(dpy, 1);

	keycode = 50;
    is_down=1;

    XTestFakeKeyEvent(dpy, keycode, is_down, 0);
    XSync(dpy, 1);

    keycode = 27;
    is_down=1;

    XTestFakeKeyEvent(dpy, keycode, is_down, 0);
    XSync(dpy, 1);

    keycode = 27;
    is_down=0;

    XTestFakeKeyEvent(dpy, keycode, is_down, 0);
    XSync(dpy, 1);

    keycode = 50;
    is_down=0;

    XTestFakeKeyEvent(dpy, keycode, is_down, 0);
    XSync(dpy, 1);

    keycode = 37;
    is_down=0;

    XTestFakeKeyEvent(dpy, keycode, is_down, 0);
    XSync(dpy, 1);

    DebugPrint("Ctrl-shift-r");
	execShellCommand("dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:\"Toggled rotation\"");

    return true;
}


bool Launcher::TextReflow()
{
    keycode = 37;
    is_down=1;

    XTestFakeKeyEvent(dpy, keycode, is_down, 0);
    XSync(dpy, 1);

    keycode = 50;
    is_down=1;

    XTestFakeKeyEvent(dpy, keycode, is_down, 0);
    XSync(dpy, 1);

    keycode = 31;
    is_down=1;

    XTestFakeKeyEvent(dpy, keycode, is_down, 0);
    XSync(dpy, 1);

    keycode = 31;
    is_down=0;

    XTestFakeKeyEvent(dpy, keycode, is_down, 0);
    XSync(dpy, 1);

    keycode = 50;
    is_down=0;

    XTestFakeKeyEvent(dpy, keycode, is_down, 0);
    XSync(dpy, 1);

    keycode = 37;
    is_down=0;

    XTestFakeKeyEvent(dpy, keycode, is_down, 0);
    XSync(dpy, 1);

    DebugPrint("Ctrl-shift-i");
	execShellCommand("dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:\"Text reflow\"");

    return true;
}


bool Launcher::Menu()
{
	Dashboard();
	usleep(100000);
	DebugPrint("launching menu");
	XTestFakeMotionEvent(dpy, DefaultScreen(dpy), 2, 2, CurrentTime);
	XTestFakeButtonEvent(dpy, Button1, True, CurrentTime);
	XTestFakeButtonEvent(dpy, Button1, False, CurrentTime);
	  
return true;

}

bool Launcher::Phone()
{
 	if (connPhone==NULL)
        {
                connectToDbusPhone();
                        if (connPhone==NULL)
                                return false;
        }


        msgPhone = dbus_message_new_method_call("com.nokia.HildonDesktop.AppMgr",
                                                "/com/nokia/HildonDesktop/AppMgr",
                                                "com.nokia.HildonDesktop.AppMgr",
                                                "LaunchApplication");

        if (NULL == msgPhone)
        {
                DebugPrint("PHONE: Message Null");
                return false;
        }

        dbus_message_iter_init_append(msgPhone, &argsPhone);
        if (!dbus_message_iter_append_basic(&argsPhone, DBUS_TYPE_STRING, &paramPhone))
        {
                DebugPrint("PHONE: Out Of Memory");
                return false;
        }

        if (!dbus_connection_send_with_reply (connPhone, msgPhone, &pendingPhone, -1))
        {
                DebugPrint("PHONE: Out of Memory");
                return false;
        }

        if (NULL == pendingPhone)
        {
                DebugPrint("PHONE: Pending Call Null");
                return false;
        }

        dbus_connection_flush(connPhone);
        dbus_message_unref(msgPhone);
        dbus_pending_call_block(pendingPhone);
        msgPhone = dbus_pending_call_steal_reply(pendingPhone);

        if (NULL == msgPhone)
        {
                DebugPrint("PHONE: Reply Null");
                return false;
        }
   dbus_pending_call_unref(pendingPhone);
   DebugPrint("PHONE: launched");


return true;
}


bool Launcher::userMenu()
{
	return execShellCommand("/usr/bin/run-standalone.sh /usr/bin/scd-usermenu");
}


bool Launcher::shellCommand()
{
	return execShellCommand(defaultShellCommand);
}


bool Launcher::execShellCommand(std::string cmd)
{
	if( cmd=="" )
		return false;

	if( cmd.at(cmd.length()-1) != '&' )
		cmd.append(" &>/dev/null &");

	DebugPrint("Launching shell command:");
	DebugPrint(cmd);

	int ret = system(cmd.c_str());
	if( ret==0 )
		return true;
	return false;
}

bool Launcher::switchToDesktop()
{
	Window win = getDesktopWindow();

	if (win == None)
		return false;

	//wmctrl rip
	XEvent event;

	event.xclient.type = ClientMessage;
	event.xclient.serial = 0;
	event.xclient.send_event = True;
	event.xclient.message_type = XInternAtom (dpy, "_NET_ACTIVE_WINDOW", False);
	event.xclient.window = win;
	event.xclient.format = 32;
	event.xclient.data.l[0] = 0;
	event.xclient.data.l[1] = 0;
	event.xclient.data.l[2] = 0;
	event.xclient.data.l[3] = 0;
	event.xclient.data.l[4] = 0;

	if (XSendEvent (dpy, DefaultRootWindow (dpy), False, SubstructureRedirectMask | SubstructureNotifyMask, &event))
	{
		XMapRaised(dpy, win);
		return true;
	}
	else return false;
}

/*
bool Launcher::isCameraUiOpen()
{
	Window r,p,*cl;
	unsigned int nc;

	int res = XQueryTree(dpy, win, &r, &p, &cl, &nc);
	if( res==0 || nc==0 ) {
		DebugPrint("Failed to detect camera UI");
		return false;
	}
	XClassHint clhint;
	Window camwin = 0;
	for(unsigned int i=0; i<nc; i++)
	{
		res = XGetClassHint(dpy, cl[i], &clhint);
		std::string resn = clhint.res_name;
		if( resn == "camera-ui" ) {
			camwin = cl[i];
			break;
		}
	}
	XFree(cl);

	XWindowAttributes attr;
	XGetWindowAttributes(dpy, camwin, &attr);

	if( attr.map_state == IsViewable ) {
		DebugPrint("Camera-ui detected to be open");
		return true;
	}

	DebugPrint("No open camera-ui detected");
	return false;
}
*/

bool Launcher::connectToDbusPhone()
{
	DebugPrint("coonecting to dbus phone");
	 dbus_error_init(&errPhone);
	 connPhone=dbus_bus_get_private(DBUS_BUS_SESSION, &errPhone);
	
	 if (dbus_error_is_set(&errPhone))
	 {
		 DebugPrint("PHONE: Connection Error");
		 dbus_error_free(&errPhone);
	 }
	
	 if (NULL == connPhone)
	 {
		 return false;
	 }
	 
	 connectedPhone=1;
	 return true;

}

void Launcher::StartZoom()
{
	// for experimental zoom feature (not enabled)

	if( stc_grab == TRUE ) {
		return;
	}

	XGrabPointer(dpy, win, FALSE, PointerMotionMask|ButtonMotionMask|ButtonPressMask|ButtonReleaseMask,
		GrabModeAsync, GrabModeAsync, None, None, CurrentTime);

	/*
	Window rr,cr;
	int cx,cy,rx,ry;
	unsigned int mr;
	XQueryPointer(dpy, win, &rr, &cr, &rx, &ry, &cx, &cy, &mr);
	DebugPrint(rx);
	DebugPrint(ry);
	*/

	stc_pointer_oldx = -1;
	stc_pointer_oldy = -1;
	stc_grab = TRUE;
	g_timeout_add(100, Launcher::GetPointerPos, NULL);

}

void Launcher::StopZoom()
{
	// for experimental zoom feature (not enabled)

	XUngrabPointer(dpy, CurrentTime);
	stc_grab = FALSE;
}

gboolean Launcher::GetPointerPos(gpointer data)
{
	// for experimental zoom feature (not enabled)

	if(stc_grab==FALSE) {
		return FALSE;
	}

	Window rr,cr;
    int cx,cy,rx,ry;
    unsigned int mr;
	int keycode,is_down;

    XQueryPointer(stc_dpy, stc_win, &rr, &cr, &rx, &ry, &cx, &cy, &mr);
    //DebugPrint(rx);
    //DebugPrint(ry);

	if(stc_pointer_oldx != -1 && stc_pointer_oldy != -1 && stc_pointer_oldx != rx && stc_pointer_oldy != ry 
		&& abs(ry-stc_pointer_oldy)<20)
	{
		if( rx < stc_pointer_oldx-10 ) {
			keycode = 73;
			is_down=1;
			XTestFakeKeyEvent(stc_dpy, keycode, is_down, 0);
			XSync(stc_dpy, 1);
			is_down=0;
			XTestFakeKeyEvent(stc_dpy, keycode, is_down, 0);
			XSync(stc_dpy, 1);
			DebugPrint("zoom in");
		}
		else if( rx > stc_pointer_oldx+10 ) {
            keycode = 74;
            is_down=1;
            XTestFakeKeyEvent(stc_dpy, keycode, is_down, 0);
            XSync(stc_dpy, 1);
            is_down=0;
            XTestFakeKeyEvent(stc_dpy, keycode, is_down, 0);
            XSync(stc_dpy, 1);
			DebugPrint("zoom out");
		}
		DebugPrint(abs(rx-stc_pointer_oldx));
	}

	stc_pointer_oldx = rx;
	stc_pointer_oldy = ry;

	return TRUE;
}

Atom Launcher::getWindowType(Window win)
{
	Atom actual_type, window_type = None;
	int actual_format;
	unsigned long nitems, bytes_after;
	unsigned char *prop_return = NULL;
	int xpropertyerr;

	xpropertyerr = XGetWindowProperty (dpy, win, XInternAtom (dpy, "_NET_WM_WINDOW_TYPE", False), 0L, (~0L), False, XA_ATOM, &actual_type, &actual_format, &nitems, &bytes_after, &prop_return);
	if (xpropertyerr != Success || nitems != 1 || !prop_return)
		return None;

	window_type = *(Atom *)prop_return;
	XFree(prop_return);
    
    return window_type;
}

//#define USE_PREDETERMINED_VAL
Window Launcher::getDesktopWindow()
{
#ifdef USE_PREDETERMINED_VAL
	return 0x01c00005;
#else
	Window root, parent, *children;
	unsigned int n_children, i;
	Window desktop = None;
	Atom _NET_WM_WINDOW_TYPE_DESKTOP = XInternAtom (dpy, "_NET_WM_WINDOW_TYPE_DESKTOP", False);

	(void) XQueryTree(dpy, win, &root, &parent, &children, &n_children);

	if (n_children == 0) {
		DebugPrint("Failed to find desktop window");
		return None;
	}

	for (i=0; i < n_children; i++)
	{
		Window win = children[i];

		if (getWindowType (win) == _NET_WM_WINDOW_TYPE_DESKTOP)
		{
			desktop = win;
			break;
		}
	}
	//printf ("0x0%lx\n", desktop);

	XFree(children);

    if (desktop == None)
        DebugPrint("Failed to find desktop window");

	return desktop;
#endif
}
