#ifndef _LAUNCHER_H_
#define _LAUNCHER_H_
#include "config.h"

#include <iostream>
#include <string>
#include <stdlib.h>

#include <ctype.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/extensions/XTest.h>
#include <unistd.h>

#include <dbus/dbus.h>
#include <dbus/dbus-glib.h>
#include <pthread.h>

#include <unistd.h>
#include "shortcutd.h"
#include <sys/types.h>
#include <sys/stat.h>


class Launcher
{
	public:
	
	Launcher();
	~Launcher();
	bool Init();
	
	bool Dashboard();
	bool Backspace();
	bool Rotation();
	bool TextReflow();
	bool Phone();
	bool Menu();
	bool userMenu();
	bool shellCommand();

	bool execShellCommand(std::string cmd);
	bool isCameraUiOpen();
	
	void StartZoom();
	void StopZoom();
	static gboolean GetPointerPos(gpointer data);

	std::string defaultShellCommand;

	private:

		Display *dpy;
                int scr;
                Window win;
                unsigned int width, height;
                int keycode , is_down;

                FILE *fp;

                Window ret_win;
                int x, y;
                unsigned int border_width, depth;

                int connectedPhone;
                DBusMessage* msgPhone;
                DBusMessageIter argsPhone;
                DBusConnection* connPhone;
                DBusError errPhone;
                int retPhone;
                DBusPendingCall* pendingPhone;
                int stat;
                dbus_uint32_t level;
                const char* paramPhone;

		bool connectToDbusPhone();

			static Display* stc_dpy;
			static Window stc_win;
			static bool stc_grab;
			static int stc_pointer_oldx;
			static int stc_pointer_oldy;

};


#endif
