#ifndef _CAMKEY_H_
#define _CAMKEY_H_

#include <glib.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>
#include <libhal.h>
#include <string.h>
#include <signal.h>
#include "launcher.h"

class Launcher;

class CameraKey
{
	public:
	CameraKey(Launcher* launcher_);
	~CameraKey();
	bool Init();
	DBusConnection* GetSysDBus();

	std::string shortPress;
	std::string longPress;
	
	private:
	Launcher* launcher;
	
	static void PropertyModified( LibHalContext* ctx, const char* udi, const char* key,
                            dbus_bool_t is_removed, dbus_bool_t is_added);
	static void AlarmHandler(int sig);

	static CameraKey* me;
	//GMainLoop* g_loop;
	//DBusConnection* dbus_sess;
	DBusConnection* dbus_sys;
	DBusMessage* msg_dashboard;
	bool initSuccess;
	
	bool doShortPress();
	bool doLongPress();
	
	static DBusError dbus_err;
	static LibHalContext* halctx;
	static int shutter_state;
	static bool timeExpired;
};


#endif
