#include <hildon-cp-plugin/hildon-cp-plugin-interface.h>
#include <gtk/gtk.h>
#include <hildon/hildon.h>
#include "../config.h"
#include "../shortcutd.h"
#include <string>
#include <vector>
#include <stdlib.h>

const int debug = 0;

int getSelectorIndex(std::vector<std::string> actions_, std::string configStr_);


osso_return_t execute(osso_context_t *osso, gpointer data, gboolean user_activated)
{
	GtkWidget *dialog, *banner, *pannable, *vbox, *check_cam, *check_prox,
		*pick_proxshort, *pick_proxlong, *pick_camshort, *pick_camlong,
		*select_proxshort, *select_proxlong, *select_camshort, *select_camlong;
	gint response;
	
	Config* conf = new Config(NULL, NULL);
	conf->readConfig();

	dialog = gtk_dialog_new_with_buttons(
		"Shortcutd configuration",
		GTK_WINDOW(data),
		GTK_DIALOG_MODAL,
		GTK_STOCK_OK,
		GTK_RESPONSE_OK,
		GTK_STOCK_CANCEL,
		GTK_RESPONSE_CANCEL,
		NULL);

	pannable = hildon_pannable_area_new();
	vbox = gtk_vbox_new(FALSE,0);

	check_cam = hildon_check_button_new(HILDON_SIZE_FINGER_HEIGHT);
	gtk_button_set_label(GTK_BUTTON(check_cam), "Use the camera button");

	check_prox = hildon_check_button_new(HILDON_SIZE_FINGER_HEIGHT);
	gtk_button_set_label(GTK_BUTTON(check_prox), "Use the proximity sensor");

	pick_proxshort = hildon_picker_button_new(HILDON_SIZE_FINGER_HEIGHT,
		HILDON_BUTTON_ARRANGEMENT_VERTICAL);
	hildon_button_set_title(HILDON_BUTTON(pick_proxshort), "Proximity sensor short press action");

	pick_proxlong = hildon_picker_button_new(HILDON_SIZE_FINGER_HEIGHT,
        HILDON_BUTTON_ARRANGEMENT_VERTICAL);
    hildon_button_set_title(HILDON_BUTTON(pick_proxlong), "Proximity sensor long press action");

	pick_camshort = hildon_picker_button_new(HILDON_SIZE_FINGER_HEIGHT,
        HILDON_BUTTON_ARRANGEMENT_VERTICAL);
    hildon_button_set_title(HILDON_BUTTON(pick_camshort), "Camera focus short press action");

	pick_camlong = hildon_picker_button_new(HILDON_SIZE_FINGER_HEIGHT,
        HILDON_BUTTON_ARRANGEMENT_VERTICAL);
    hildon_button_set_title(HILDON_BUTTON(pick_camlong), "Camera focus long press action");

	gtk_button_set_alignment(GTK_BUTTON(pick_camshort), 0.0, 0.5);
	gtk_button_set_alignment(GTK_BUTTON(pick_camlong), 0.0, 0.5);
	gtk_button_set_alignment(GTK_BUTTON(pick_proxshort), 0.0, 0.5);
    gtk_button_set_alignment(GTK_BUTTON(pick_proxlong), 0.0, 0.5);
	
    select_camshort = hildon_touch_selector_new_text();
    hildon_touch_selector_set_column_selection_mode(HILDON_TOUCH_SELECTOR(select_camshort),
        HILDON_TOUCH_SELECTOR_SELECTION_MODE_SINGLE);

    select_camlong = hildon_touch_selector_new_text();
    hildon_touch_selector_set_column_selection_mode(HILDON_TOUCH_SELECTOR(select_camlong),
        HILDON_TOUCH_SELECTOR_SELECTION_MODE_SINGLE);

	select_proxshort = hildon_touch_selector_new_text();
	hildon_touch_selector_set_column_selection_mode(HILDON_TOUCH_SELECTOR(select_proxshort),
		HILDON_TOUCH_SELECTOR_SELECTION_MODE_SINGLE);

    select_proxlong = hildon_touch_selector_new_text();
    hildon_touch_selector_set_column_selection_mode(HILDON_TOUCH_SELECTOR(select_proxlong),
		HILDON_TOUCH_SELECTOR_SELECTION_MODE_SINGLE);
	
	// the lengths of these vectors must match!
	std::vector<std::string> launch_descriptions;
	launch_descriptions.push_back("Disabled");
	launch_descriptions.push_back("Dashboard");
	launch_descriptions.push_back("Launch phone");
	launch_descriptions.push_back("Menu");
	launch_descriptions.push_back("Backspace (Browser: back)");

	std::vector<std::string> launch_actions;
	launch_actions.push_back("disabled");
	launch_actions.push_back("dashboard");
	launch_actions.push_back("phone");
	launch_actions.push_back("menu");
	launch_actions.push_back("backspace");

	for(unsigned int i=0; i<launch_descriptions.size(); i++)
	{
		hildon_touch_selector_append_text(HILDON_TOUCH_SELECTOR(select_proxlong), launch_descriptions.at(i).c_str());
		hildon_touch_selector_append_text(HILDON_TOUCH_SELECTOR(select_proxshort), launch_descriptions.at(i).c_str());
		hildon_touch_selector_append_text(HILDON_TOUCH_SELECTOR(select_camshort), launch_descriptions.at(i).c_str());
		hildon_touch_selector_append_text(HILDON_TOUCH_SELECTOR(select_camlong), launch_descriptions.at(i).c_str());
	}

	hildon_picker_button_set_selector(HILDON_PICKER_BUTTON(pick_proxshort),
		HILDON_TOUCH_SELECTOR(select_proxshort));
	hildon_picker_button_set_selector(HILDON_PICKER_BUTTON(pick_proxlong),
		HILDON_TOUCH_SELECTOR(select_proxlong));
    hildon_picker_button_set_selector(HILDON_PICKER_BUTTON(pick_camshort),
        HILDON_TOUCH_SELECTOR(select_camshort));	
    hildon_picker_button_set_selector(HILDON_PICKER_BUTTON(pick_camlong),
        HILDON_TOUCH_SELECTOR(select_camlong));	

	gtk_box_pack_start(GTK_BOX(vbox), check_cam, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(vbox), pick_camshort, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(vbox), pick_camlong, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(vbox), check_prox, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(vbox), pick_proxshort, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(vbox), pick_proxlong, FALSE, FALSE, 0);

	hildon_pannable_area_set_size_request_policy(
		HILDON_PANNABLE_AREA(pannable), HILDON_SIZE_REQUEST_CHILDREN);
	hildon_pannable_area_add_with_viewport(
		HILDON_PANNABLE_AREA(pannable), vbox);
	gtk_container_add(GTK_CONTAINER(GTK_DIALOG(dialog)->vbox), pannable);

	// set the widget values from config
	hildon_check_button_set_active(HILDON_CHECK_BUTTON(check_cam), (gboolean)conf->camerakeyOn);
	hildon_check_button_set_active(HILDON_CHECK_BUTTON(check_prox), (gboolean)conf->proximityOn);
	hildon_picker_button_set_active(HILDON_PICKER_BUTTON(pick_camshort), getSelectorIndex(launch_actions, conf->ck_shortPress));
	hildon_picker_button_set_active(HILDON_PICKER_BUTTON(pick_camlong), getSelectorIndex(launch_actions, conf->ck_longPress));
	hildon_picker_button_set_active(HILDON_PICKER_BUTTON(pick_proxshort), getSelectorIndex(launch_actions, conf->ps_shortPress));
	hildon_picker_button_set_active(HILDON_PICKER_BUTTON(pick_proxlong), getSelectorIndex(launch_actions, conf->ps_longPress));

	gtk_widget_show_all(dialog);

	if (!user_activated)
	{
		/* ... load state ... */
	}

	/* Wait until user finishes the dialog. */
	response = gtk_dialog_run(GTK_DIALOG(dialog));

	if (response == GTK_RESPONSE_OK)
	{
		// maybe should check if settings have really changed before
		// writing, restarting & killing

		conf->proximityOn = (int)hildon_check_button_get_active(HILDON_CHECK_BUTTON(check_prox));
		conf->camerakeyOn = (int)hildon_check_button_get_active(HILDON_CHECK_BUTTON(check_cam));;
		if( hildon_picker_button_get_active(HILDON_PICKER_BUTTON(pick_proxshort)) != -1 )
			conf->ps_shortPress = launch_actions.at( hildon_picker_button_get_active(HILDON_PICKER_BUTTON(pick_proxshort)) );
		if( hildon_picker_button_get_active(HILDON_PICKER_BUTTON(pick_proxlong)) != -1 )
			conf->ps_longPress = launch_actions.at( hildon_picker_button_get_active(HILDON_PICKER_BUTTON(pick_proxlong)) );
		if( hildon_picker_button_get_active(HILDON_PICKER_BUTTON(pick_camshort)) != -1 )
			conf->ck_shortPress = launch_actions.at( hildon_picker_button_get_active(HILDON_PICKER_BUTTON(pick_camshort)) );
		if( hildon_picker_button_get_active(HILDON_PICKER_BUTTON(pick_camlong)) != -1 )
			conf->ck_longPress = launch_actions.at( hildon_picker_button_get_active(HILDON_PICKER_BUTTON(pick_camlong)) );

		conf->writeConfigFile();

		int ret = system("killall shortcutd");
		if( ret == 0 ) {
			banner = hildon_banner_show_information(GTK_WIDGET(data), NULL,
				"Restarting shortcutd");
			hildon_banner_set_timeout(HILDON_BANNER(banner), 5000);
		} else {
            banner = hildon_banner_show_information(GTK_WIDGET(data), NULL,
                "Failed to restart shortcutd!");
            hildon_banner_set_timeout(HILDON_BANNER(banner), 5000);
		}
	}

	/* Free the dialog (and it's children) */
	gtk_widget_destroy(GTK_WIDGET(dialog));
	delete conf;
	return OSSO_OK;
}

int getSelectorIndex(std::vector<std::string> actions_, std::string configStr_)
{
	int i=0;
	for(i=0; i<(int)actions_.size(); i++)
	{
		if( configStr_ == actions_.at(i))
			break;
	}
	if(i==(int)actions_.size())
		i=0;

	return i;
}

osso_return_t save_state(osso_context_t *osso, gpointer data)
{
	/* ... save state ... */
	return OSSO_OK;
}

void DebugPrint(std::string msg)
{
    if (debug)
        std::cerr << "shortcutd cp applet " << VERSION << ": " << msg << std::endl;

}

void DebugPrint(int msg)
{
    if (debug)
        std::cerr << "shortcutd cp applet " << VERSION << ": " << msg << std::endl;
}
