#include "launcher.h"

Launcher::Launcher()
{

	Init();


}

Launcher::~Launcher()
{



}


bool Launcher::Init()
{
	DebugPrint("phone init");
	connectToDbusPhone();
	paramPhone="rtcom-call-ui";
	
	dpy = XOpenDisplay(getenv("DISPLAY"));
        
	if (!dpy)
	{
		DebugPrint("dpy null");
		exit(1);
	}
	
	scr = DefaultScreen(dpy);
	win = RootWindow(dpy, scr);
	XGetGeometry(dpy, win, &ret_win, &x, &y, &width, &height, &border_width, &depth);
	XSynchronize(dpy, True);
		
	


return true;
}


bool Launcher::Dashboard()
{
	keycode = 37;
	is_down=1;

        XTestFakeKeyEvent(dpy, keycode, is_down, 0);
        XSync(dpy, 1);

        keycode = 22;
        is_down=1;

        XTestFakeKeyEvent(dpy, keycode, is_down, 0);
        XSync(dpy, 1);

        keycode = 22;
        is_down=0;

        XTestFakeKeyEvent(dpy, keycode, is_down, 0);
        XSync(dpy, 1);

        keycode = 37;
        is_down=0;

        XTestFakeKeyEvent(dpy, keycode, is_down, 0);
        XSync(dpy, 1);

        DebugPrint("DASH: launched");


	return true;
}


bool Launcher::Backspace()
{
	keycode = 22;
	is_down=1;

	XTestFakeKeyEvent(dpy, keycode, is_down, 0);
	XSync(dpy, 1);

	keycode = 22;
	is_down=0;

	XTestFakeKeyEvent(dpy, keycode, is_down, 0);
	XSync(dpy, 1);

	DebugPrint("backspace sent");

	return true;
}


bool Launcher::Menu()
{
	Dashboard();
	DebugPrint("launching menu");
	XTestFakeMotionEvent(dpy, DefaultScreen(dpy), 2, 2, CurrentTime);
	XTestFakeButtonEvent(dpy, Button1, True, CurrentTime);
	XTestFakeButtonEvent(dpy, Button1, False, CurrentTime);
	  
return true;

}

bool Launcher::Phone()
{
 	if (connPhone==NULL)
        {
                connectToDbusPhone();
                        if (connPhone==NULL)
                                return false;
        }


        msgPhone = dbus_message_new_method_call("com.nokia.HildonDesktop.AppMgr",
                                                "/com/nokia/HildonDesktop/AppMgr",
                                                "com.nokia.HildonDesktop.AppMgr",
                                                "LaunchApplication");

        if (NULL == msgPhone)
        {
                DebugPrint("PHONE: Message Null");
                return false;
        }

        dbus_message_iter_init_append(msgPhone, &argsPhone);
        if (!dbus_message_iter_append_basic(&argsPhone, DBUS_TYPE_STRING, &paramPhone))
        {
                DebugPrint("PHONE: Out Of Memory");
                return false;
        }

        if (!dbus_connection_send_with_reply (connPhone, msgPhone, &pendingPhone, -1))
        {
                DebugPrint("PHONE: Out of Memory");
                return false;
        }

        if (NULL == pendingPhone)
        {
                DebugPrint("PHONE: Pending Call Null");
                return false;
        }

        dbus_connection_flush(connPhone);
        dbus_message_unref(msgPhone);
        dbus_pending_call_block(pendingPhone);
        msgPhone = dbus_pending_call_steal_reply(pendingPhone);

        if (NULL == msgPhone)
        {
                DebugPrint("PHONE: Reply Null");
                return false;
        }
   dbus_pending_call_unref(pendingPhone);
   DebugPrint("PHONE: launched");


return true;
}



bool Launcher::connectToDbusPhone()
{
	DebugPrint("coonecting to dbus phone");
	 dbus_error_init(&errPhone);
	 connPhone=dbus_bus_get_private(DBUS_BUS_SESSION, &errPhone);
	
	 if (dbus_error_is_set(&errPhone))
	 {
		 DebugPrint("PHONE: Connection Error");
		 dbus_error_free(&errPhone);
	 }
	
	 if (NULL == connPhone)
	 {
		 return false;
	 }
	 
	 connectedPhone=1;
	 return true;

}
