/*
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "shortcutd.h"
#include "proximity.h"
#include "camkey.h"
#include "config.h"
#include <fstream>
#include <iostream>
#include <glib.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>

static int debug=0;


int main(int argc, char** argv)
{
	GMainLoop* g_loop = NULL;

	if (argc>1)
	{
		if (strcmp(argv[1],"-d")==0)
		{
			debug=1;
		}
	}

	DebugPrint("debug mode ON");
	
	g_loop = g_main_loop_new(NULL, FALSE);
	if( g_loop == NULL ) {
		DebugPrint("glib main loop creation failed");
		return 1;
	}
	DebugPrint("glib main loop created");

	ProximitySensor* ps;
	CameraKey* ck;

	DebugPrint("creating ps");
	ps = new ProximitySensor;
	DebugPrint("...ok");
	DebugPrint("reading config");
	Config* conf = new Config(ps,ck);
	conf->readConfig();
	DebugPrint("...ok");
	if (conf->proximityOn==1)	
	{
		DebugPrint("starting ps");
		ps->start();
		DebugPrint("...ok");
	}
	else
	{
		DebugPrint("proximity sensor disabled");
	}
	
	DebugPrint("creating ck");
	ck = new CameraKey;
	DebugPrint("...ok");

	if( conf->camerakeyOn==1 )
	{	
		if( !ck->Init() )
		{
			DebugPrint("ck init failed");
			return 1;
		}
		dbus_connection_setup_with_g_main(ck->GetSysDBus(), NULL);
	} else {
		DebugPrint("camera button is disabled");
	}

	if( conf->proximityOn==1 )
	{
		DBusError* derr;
		dbus_connection_setup_with_g_main(ps->GetSessionDBus(), NULL);
		
		dbus_connection_setup_with_g_main(ps->GetSystemDBus(), NULL);

		dbus_bus_add_match(ps->GetSessionDBus(), "proximityd.signal.state", derr );
		
		dbus_bus_add_match(ps->GetSystemDBus(), "com.nokia.mce.signal", derr );
		
		dbus_connection_add_filter(ps->GetSessionDBus(), ProximitySensor::DBusCallback, g_loop, NULL);
		
		dbus_connection_add_filter(ps->GetSystemDBus(), ProximitySensor::DBusCallback, g_loop, NULL);
	}


	DebugPrint("entering loop");
	g_main_loop_run( g_loop );

	return 0;
}
	

void DebugPrint(std::string msg)
{
	if (debug)
		std::cerr << "shortcutd " << VERSION << ": " << msg << std::endl;
	
}

void DebugPrint(int msg)
{
	if (debug)
		std::cerr << "shortcutd " << VERSION << ": " << msg << std::endl;
}
