#include "proximity.h"


ProximitySensor* ProximitySensor::me=NULL;

ProximitySensor::ProximitySensor()
{

	tapDuration=60;
	tapDelta=50;
	idleResetDuration=500;
	dashDuration=300;
	disableDuration=1000;
	phoneDuration=500;

	shortPress="dashboard";
	longPress="phone";
	hold="proximityToggle";

	paramPhone="rtcom-call-ui";
	paramVib="PatternTocuhScreen";

	tap=0;
	on=1;
	counter=0;
	idleCounter=0;
	keyboardLocked=0;
	connectedLock = 0;
	connectedVib=0;
	connectedProx=0;
	inCheck=0;

	interval=INTERVAL_ACTIVE;
	me=this;

}


void ProximitySensor::start()
{

	connectToDbusVibra();
	connectToDbusLock();
	connectToDbusPhone();
	connectToDbusProx();
	dpy = XOpenDisplay("");

	if (!dpy) 
	{
		exit(1);
	}

	ppid = getpid();
	scr = DefaultScreen(dpy);
	win = RootWindow(dpy, scr);
	XGetGeometry(dpy, win, &ret_win, &x, &y, &width, &height, &border_width, &depth);
	sleep(5);
	startSensor();

}



void ProximitySensor::connectToDbusVibra()
{
	dbus_error_init(&errVib);
	connVib = dbus_bus_get_private(DBUS_BUS_SYSTEM, &errVib);
	if (dbus_error_is_set(&errVib)) 
	{
		DebugPrint("VIBRA: Connection Error");
		dbus_error_free(&errVib);
	}
	if (NULL == connVib) 
	{
		return;
	}

	retVib = dbus_bus_request_name(connVib, "proximity.vibra", DBUS_NAME_FLAG_REPLACE_EXISTING , &errVib);
	if (dbus_error_is_set(&errVib)) 
	{
		DebugPrint("VIBRA: Name Error");
		dbus_error_free(&errVib);
	}
	if (DBUS_REQUEST_NAME_REPLY_PRIMARY_OWNER != retVib) 
	{
		return;
	}

	connectedVib=1;
}



void ProximitySensor::vibrate(int type)
{
	if (type==0) //change this to enum
	{
		paramVib = "PatternTouchscreen";
	}
	else if (type==1)
	{
		paramVib = "PatternPowerKeyPress";
	}
	else if (type==2)
	{
		paramVib= "PatternChatAndEmail";
	}

	if (connectedVib==0)
	{
		connectToDbusVibra();
		if (connectedVib==0)
			return;
	}
   
	msgVib = dbus_message_new_method_call("com.nokia.mce",                                     
										"/com/nokia/mce/request", 
										"com.nokia.mce.request", 
										"req_vibrator_pattern_activate"); 
   
   if (NULL == msgVib) 
	{
		DebugPrint("VIBRA: Message Null");
		return;
	}


   dbus_message_iter_init_append(msgVib, &argsVib);
   if (!dbus_message_iter_append_basic(&argsVib, DBUS_TYPE_STRING, &paramVib)) 
   {
		DebugPrint("VIBRA: Out of Memory");
		return;
   }

	if (!dbus_connection_send_with_reply (connVib, msgVib, &pendingVib, -1)) 
	{
		DebugPrint("VIBRA: Out of Memory");
		return;
	}
	if (NULL == pendingVib) 
	{
		DebugPrint("VIBRA: Pending Call Null");
		return;
	}
	
	dbus_connection_flush(connVib);
	dbus_message_unref(msgVib);

}

void ProximitySensor::connectToDbusProx()
{
	dbus_error_init(&errProx);
	connProx = dbus_bus_get_private(DBUS_BUS_SESSION, &errProx);
	if (dbus_error_is_set(&errProx)) 
	{
		DebugPrint("PROX: Connection Error ");
		dbus_error_free(&errProx);
   }
   if (NULL == connProx) 
   {
		return;
   }

   retProx = dbus_bus_request_name(connProx, "proximity.prox", DBUS_NAME_FLAG_REPLACE_EXISTING , &errProx);
   
   if (dbus_error_is_set(&errProx)) 
   {
		DebugPrint("PROX: Name Error ");
		dbus_error_free(&errProx);
   }
   if (DBUS_REQUEST_NAME_REPLY_PRIMARY_OWNER != retProx) 
   {
      return;
   }

   dbus_bus_add_match(connProx, "type='signal',interface='proximityd.signal.state'", &errProx);
   dbus_connection_flush(connProx);
   if (dbus_error_is_set(&errProx)) 
   {
		DebugPrint("PROX: Match Error ");
		return;
   }
	connectedProx=1;
}


char ProximitySensor::readProx()
{

	if (connectedProx==0)
	{
		connectToDbusProx();
		if (connectedProx==0)
			return 'e';
	}

	dbus_connection_read_write(connProx, 0);
	msgProx = dbus_connection_pop_message(connProx);

	if (NULL == msgProx) 
	{
		return currentState;
	}

	else
	{
		if (dbus_message_is_signal(msgProx, "proximityd.signal.state", "changed")) 
		{
			if (!dbus_message_iter_init(msgProx, &argsProx))
				DebugPrint("PROX: Message Has No Parameters");
			else if (DBUS_TYPE_STRING != dbus_message_iter_get_arg_type(&argsProx))
				DebugPrint("PROX: Argument is not string");
			else
				dbus_message_iter_get_basic(&argsProx, &sigvalueProx);

			if (sigvalueProx[0]=='c')
			{
				return 'c';
			}
			else if (sigvalueProx[0]=='o')
			{
				return 'o';
			}
		}
	}
return currentState;
}


void ProximitySensor::connectToDbusLock()
{
	dbus_error_init(&errLock);
	connLock = dbus_bus_get_private(DBUS_BUS_SYSTEM, &errLock);
	if (dbus_error_is_set(&errLock)) 
	{
		DebugPrint("LOCK: Connection Error");
		dbus_error_free(&errLock);
   }
   if (NULL == connLock) 
   {
		return;
   }

   retLock = dbus_bus_request_name(connLock, "proximity.lock", DBUS_NAME_FLAG_REPLACE_EXISTING , &errLock);
   
   if (dbus_error_is_set(&errLock)) 
   {
		DebugPrint("LOCK: Name Error");
		dbus_error_free(&errLock);
   }
   if (DBUS_REQUEST_NAME_REPLY_PRIMARY_OWNER != retLock) 
   {
      return;
   }

   dbus_bus_add_match(connLock, "type='signal',interface='com.nokia.mce.signal'", &errLock);
   dbus_connection_flush(connLock);
   if (dbus_error_is_set(&errLock)) 
   {
		DebugPrint("LOCK: Match Error");
		return;
   }
	connectedLock=1;
}





void ProximitySensor::startSensor()
{


	std::string parameter = "turnOn";
		     


	msgProxSen = dbus_message_new_method_call("proximityd.method.change",
				           "/proximityd/method/change", 
					   "proximityd.method.change", 
					   "Change"); 

	if (NULL == msgProxSen) 
	{
		DebugPrint("SENSOR: Message Null");
		return;
	}


	dbus_message_iter_init_append(msgProxSen, &argsProxSen);
	   
	if (!dbus_message_iter_append_basic(&argsProxSen, DBUS_TYPE_STRING, &parameter)) 
	{
		DebugPrint("SENSOR: Out Of Memory 1");
		return;
	
	}

	   
	if (!dbus_message_iter_append_basic(&argsProxSen, DBUS_TYPE_INT32, &ppid)) 
	{
		DebugPrint("SENSOR: Out Of Memory 2");
		return;
	
	}

	if (!dbus_connection_send_with_reply (connProx, msgProxSen, &pendingProxSen, -1)) 
	{ 
		DebugPrint("SENSOR: Out Of Memory 3");
      		return;
   	}

	
	if (NULL == pendingProxSen)	  
	{
		DebugPrint("SENSOR: Pending Call Null");
		return;
		          
	}

	DebugPrint("SENSOR: started");
}

void ProximitySensor::stopSensor()
{

	std::string parameter = "turnOff";
		     
	msgProxSen = dbus_message_new_method_call("proximityd.method.change",
				           "/proximityd/method/change", 
					   "proximityd.method.change", 
					   "Change"); 

	if (NULL == msgProxSen) 
	{
		DebugPrint("SENSOR: Message Null");
		return;
	}


	dbus_message_iter_init_append(msgProxSen, &argsProxSen);
	   
	if (!dbus_message_iter_append_basic(&argsProxSen, DBUS_TYPE_STRING, &parameter)) 
	{
		DebugPrint("SENSOR: Out Of Memory");
		return;
	
	}

		   
	if (!dbus_message_iter_append_basic(&argsProxSen, DBUS_TYPE_INT32, &ppid)) 
	{
		DebugPrint("SENSOR: Out Of Memory");
		return;
	
	}

	if (!dbus_connection_send_with_reply (connProx, msgProxSen, &pendingProxSen, -1)) 
	{ 
		DebugPrint("SENSOR: Out Of Memory");
      		return;
   	}
   
	if (NULL == pendingProxSen)	  
	{
		DebugPrint("SENSOR: Pending Call Null");
		return;
		          
	}


	DebugPrint("SENSOR: stopped");
}






void ProximitySensor::connectToDbusPhone()
{
	dbus_error_init(&errPhone);
	connPhone=dbus_bus_get_private(DBUS_BUS_SESSION, &errPhone);

	if (dbus_error_is_set(&errPhone)) 
	{ 
		DebugPrint("PHONE: Connection Error");
		dbus_error_free(&errPhone); 
	}

	if (NULL == connPhone) 
	{ 
		return; 
	}

	connectedPhone=1;

}


void ProximitySensor::launchPhone()
{

	if (connPhone==NULL)
	{
		connectToDbusPhone();
			if (connPhone==NULL)
				return;
	}	


	msgPhone = dbus_message_new_method_call("com.nokia.HildonDesktop.AppMgr", 
						"/com/nokia/HildonDesktop/AppMgr",
						"com.nokia.HildonDesktop.AppMgr", 
						"LaunchApplication"); 
   
	if (NULL == msgPhone)
	{	
		DebugPrint("PHONE: Message Null");
		return;
	}

	dbus_message_iter_init_append(msgPhone, &argsPhone);
	if (!dbus_message_iter_append_basic(&argsPhone, DBUS_TYPE_STRING, &paramPhone)) 
	{
		DebugPrint("PHONE: Out Of Memory");
		return;
	}

	if (!dbus_connection_send_with_reply (connPhone, msgPhone, &pendingPhone, -1)) 
	{
		DebugPrint("PHONE: Out of Memory");
		return;
	}
	
	if (NULL == pendingPhone) 
	{
		DebugPrint("PHONE: Pending Call Null");
		return;
	}
	
	dbus_connection_flush(connPhone);
	dbus_message_unref(msgPhone);
	dbus_pending_call_block(pendingPhone);
	msgPhone = dbus_pending_call_steal_reply(pendingPhone);
  
	if (NULL == msgPhone) 
	{
		DebugPrint("PHONE: Reply Null");
		return;
	}
   dbus_pending_call_unref(pendingPhone);
   DebugPrint("PHONE: launched");
}

void ProximitySensor::dash()
{
	//vibrate(0);
	
	keycode = 37;
	is_down=1;

	XTestFakeKeyEvent(dpy, keycode, is_down, 0);
	XSync(dpy, 1);

	keycode = 22;
	is_down=1;

	XTestFakeKeyEvent(dpy, keycode, is_down, 0);
	XSync(dpy, 1);

	keycode = 22;
	is_down=0;

	XTestFakeKeyEvent(dpy, keycode, is_down, 0);
	XSync(dpy, 1);

	keycode = 37;
	is_down=0;

	XTestFakeKeyEvent(dpy, keycode, is_down, 0);
	XSync(dpy, 1);

	DebugPrint("DASH: launched");
}


void ProximitySensor::doShortPress()
{
	if (shortPress.compare("dashboard")==0)
		dash();


}

void ProximitySensor::doLongPress()
{
	if (longPress.compare("phone")==0)
		launchPhone();

}


void ProximitySensor::doHold()
{
	if (hold.compare("proximityToggle")==0)
	{
		on=on?0:1;
		vibrate(2);
	}

}



void* ProximitySensor::checkSensor(void* pObject)
{

	int counter=0;
	ProximitySensor* prox = (ProximitySensor*)pObject;
	char state=prox->currentState;

	state=prox->currentState;

	if (state=='c')
		prox->vibrate(0);

	usleep(300000);
	
	state=prox->currentState;
	if (state=='c')
	{
		prox->vibrate(0);
		while(counter<2000)
		{		
			++counter;	
			state=prox->currentState;
			if (state=='o' && prox->on)
			{
				prox->inCheck=0;
				//short press
				prox->doShortPress();
				return 0;
			}
			else if (state=='o')
			{
				prox->inCheck=0;
				return 0;
			}
			usleep(100);
		}		
		counter=0;
		prox->vibrate(0);
		while(counter<1500)
		{
			++counter;
			state=prox->currentState;
			if (state=='o' && prox->on)
			{
				prox->inCheck=0;
				//long press
				prox->doLongPress();
				return 0;
			}
			else if (state=='o')
			{
				prox->inCheck=0;
				return 0;
			}
			usleep(1000);
		}
		//hold press
		prox->doHold();
	
	}


	prox->inCheck=0;
	return 0;

}


DBusHandlerResult ProximitySensor::DBusCallback( DBusConnection* connection, DBusMessage* message, void* user_data)
{
	
	char *s;
	DBusError error;
	dbus_error_init (&error);

	if (dbus_message_is_signal (message, "proximityd.signal.state", "changed"))
	{
		if (dbus_message_get_args(message, &error, DBUS_TYPE_STRING, &s, DBUS_TYPE_INVALID) && !me->keyboardLocked)
		{
			DebugPrint(s);
			if (!me->inCheck)
			{
				me->currentState=s[0];
				pthread_create(&me->sensorThread,NULL,&ProximitySensor::checkSensor, me);
				me->inCheck=1;
			}

			else
				me->currentState=s[0];
		}

	return DBUS_HANDLER_RESULT_HANDLED;
	}		

 
	else if (dbus_message_is_signal (message, "com.nokia.mce.signal", "tklock_mode_ind"))
        {
                if (dbus_message_get_args(message, &error, DBUS_TYPE_STRING, &s, DBUS_TYPE_INVALID))
                {
                        if (s[0]=='l')
                        {
				DebugPrint("keyboard locked");
				me->keyboardLocked=1;
				me->stopSensor();
                        }
                        else if (s[0]=='u')
                        {
				DebugPrint("keyboard unlocked");
				me->keyboardLocked=0;
				me->startSensor();
                        }
                }
                return DBUS_HANDLER_RESULT_HANDLED;
        }




	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


DBusConnection* ProximitySensor::GetSessionDBus()
{
	return connProx;
}

DBusConnection* ProximitySensor::GetSystemDBus()
{
	return connLock;
}
