#ifndef CONFIG_H
#define CONFIG_H

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include <locale.h>
#include <string>
#include <iostream>
#include "camkey.h"
#include "proximity.h"
#include "shortcutd.h"
#include <fstream>
extern "C"
{
#include "json/JSON_parser.h"
}

class Config
{
	private:
		const char* configDir;
		const char* configFile;
		FILE* input;
		JSON_config config;
		struct JSON_parser_struct* jc;
		int count;
		static int handleResult(void* ctx, int type, const JSON_value* value);
		static Config* me;
		int s_IsKey;
		std::string key;
		void setInt(int value_);
		void setString(std::string value_);

		ProximitySensor* ps;
		CameraKey* ck;
		void writeConfigFile();	
		
		
	public:
		Config(ProximitySensor* ps_, CameraKey* ck_);
		~Config();
		int readConfig();
		int proximityOn;
		int camerakeyOn;
		void setProximity(ProximitySensor* ps_);
		void setCameraKey(CameraKey* ck_);

};

#endif
