#include "config.h"

Config* Config::me=NULL;

Config::Config(ProximitySensor* ps_, CameraKey* ck_)
{
	configDir="/home/user/.shortcutd";
	configFile="/home/user/.shortcutd/config";
	input = fopen(configFile,"r");
	if(input) {
		init_JSON_config(&config);
	} else {
		DebugPrint("no config file found, creating default one");
		writeConfigFile();
	}

	config.depth = 20;
	config.callback = &handleResult;
	config.allow_comments = 1;
	config.handle_floats_manually = 0;
	jc = new_JSON_parser(&config);		    
	count=0;
	s_IsKey=0;
	proximityOn=1;
	camerakeyOn=1;
	ps=ps_;
	ck=ck_;
	
	me=this;
}

void Config::writeConfigFile()
{
	mkdir(configDir, 0755);

	std::ofstream f;
	f.open(configFile);

  	if (f.is_open())
  	{
		DebugPrint("creating config file");
    		f << "{\n";
    		f << "\"proximityOn\": 1,";
		f << "\n";
		f << "\"camerakeyOn\": 1,";
		f << "\n";
		f << "\"proximityShortPress\": \"dashboard\",";
		f << "\n";
		f << "\"proximityLongPress\": \"phone\",";
		f << "\n";
		f << "\"proximityHold\": \"proximityToggle\"";
		f << "\n";
    		f << "}\n";
		f.close();
  	}
	chown(configFile,29999,29999);
	chmod(configFile,0666);
	input = fopen(configFile,"r");
	if (input)
		init_JSON_config(&config);
	else
	{
		DebugPrint("cannot create config file, exiting");
		exit(1);
	}

}



void Config::setProximity(ProximitySensor* ps_)
{
ps=ps_;
}

void Config::setCameraKey(CameraKey* ck_)
{
ck=ck_;
}

int Config::readConfig()
{
	if(!input) 
		return 1;
	
	for (; input ; ++count) 
	{
		int next_char = fgetc(input);
		if (next_char <= 0) 
		{
			break;
		}
		if (!JSON_parser_char(jc, next_char)) 
		{
			delete_JSON_parser(jc);
			DebugPrint("JSON_parser_char: syntax error");
			return 1;
		}
	}
        
	if (!JSON_parser_done(jc)) 
	{
		delete_JSON_parser(jc);
		DebugPrint("JSON_parser_end: syntax error");
		return 1;
	}
	
	fclose(input);
	DebugPrint("config file closed");

	return 0;
}

void Config::setInt(int value_)
{


	if (key.compare("proximityOn")==0)
		proximityOn=value_;	
   	 if (key.compare("camerakeyOn")==0)
        	camerakeyOn=value_;
	
	DebugPrint("config SET: ");
	DebugPrint(key);
	DebugPrint(value_);

}


void Config::setString(std::string value_)
{

	if (key.compare("proximityShortPress")==0)
		ps->shortPress=value_;
	if (key.compare("proximityLongPress")==0)
		ps->longPress=value_;
	if (key.compare("proximityHold")==0)
		ps->hold=value_;

	DebugPrint("config SET: ");
	DebugPrint(key);
	DebugPrint(value_);
	
}


int Config::handleResult(void* ctx, int type, const JSON_value* value)
{
switch(type)
    {
    case JSON_T_ARRAY_BEGIN:
        me->s_IsKey = 0;
        break;
    case JSON_T_ARRAY_END:
        assert(!me->s_IsKey);
        break;
   case JSON_T_OBJECT_BEGIN:
       me->s_IsKey = 0;
       break;
    case JSON_T_OBJECT_END:
        assert(!me->s_IsKey);
        break;
    case JSON_T_INTEGER:
        me->s_IsKey = 0;
	me->setInt(value->vu.integer_value);
        break;
    case JSON_T_FLOAT:
        me->s_IsKey = 0;
        break;
    case JSON_T_NULL:
        me->s_IsKey = 0;
        break;
    case JSON_T_TRUE:
        me->s_IsKey = 0;
        break;
    case JSON_T_FALSE:
        me->s_IsKey = 0;
        break;
    case JSON_T_KEY:
        me->s_IsKey = 1;
	me->key=value->vu.str.value;
        break;
    case JSON_T_STRING:
        me->s_IsKey = 0;
	me->setString(value->vu.str.value);
        break;
    default:
        assert(0);
        break;
    }

return 1;

}


