/*
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "shortcutd.h"
#include "proximity.h"
#include "camkey.h"
#include "config.h"
#include <fstream>
#include <iostream>

static int debug=0;


int main(int argc, char** argv)
{
	if (argc>1)
	{
		if (strcmp(argv[1],"-d")==0)
		{
			debug=1;
		}
	}

	DebugPrint("debug mode ON");
	
	ProximitySensor* ps;
	CameraKey* ck;

	DebugPrint("creating ps");
	ps = new ProximitySensor;
	DebugPrint("...ok");
	DebugPrint("reading config");
	Config* conf = new Config(ps,ck);
	conf->readConfig();
	DebugPrint("...ok");
	if (conf->proximityOn==1)	
	{
		DebugPrint("starting ps");
		ps->start();
		DebugPrint("...ok");
	}
	else
	{
		DebugPrint("proximity sensor disabled");
	}
	
	DebugPrint("creating ck");
	ck = new CameraKey;
	DebugPrint("...ok");
	
	
	if( !ck->Init() )
	{
		DebugPrint("ck init failed");
		return 1;
	}


	DebugPrint("entering loop");
	
	while(1)
    {
	    if (conf->proximityOn==1)
	    {
        	ps->checkSensor();
		usleep(ps->interval);
	    }
	    else
		usleep(1000);

		// this is required to process incoming dbus messages
		//   when glib main loop integration is not used
		dbus_connection_read_write(ck->GetSysDBus(),0);
		while(dbus_connection_dispatch(ck->GetSysDBus()) == 
			DBUS_DISPATCH_DATA_REMAINS);
    }

	return 0;
}

	

void DebugPrint(std::string msg)
{
	// this should correspond to some command line argument perhaps
	// (only print when -d used)
	if (debug)
		std::cerr << "shortcutd " << VERSION << ": " << msg << std::endl;
	
}

void DebugPrint(int msg)
{
	// this should correspond to some command line argument perhaps
	// (only print when -d used)
	if (debug)
		std::cerr << "shortcutd " << VERSION << ": " << msg << std::endl;
}
