#ifndef _PROXIMITY_H_
#define _PROXIMITY_H_

#include <iostream>
#include <stdlib.h>

#include <ctype.h>
#include <X11/Xlib.h>
#include <X11/extensions/XTest.h>
#include <unistd.h>

#include <dbus/dbus.h>
#include <pthread.h>

#include <unistd.h>
#include "shortcutd.h"

#define INTERVAL_IDLE 1000000
#define INTERVAL_ACTIVE 1000


class ProximitySensor
{
	private:
		int tapDuration;
		int tapDelta;
		int idleResetDuration;
		int dashDuration;
		int disableDuration;
		int phoneDuration;

		char currentState;

		int tap;
		int on;
		int counter;
		int idleCounter;
		int keyboardLocked;

		
		Display *dpy;
		int scr;
		Window win;
		unsigned int width, height;
		int keycode , is_down;
		
		FILE *fp;
		
		Window ret_win;
		int x, y;
		unsigned int border_width, depth;

		int connectedPhone;
		DBusMessage* msgPhone;
		DBusMessageIter argsPhone;
		DBusConnection* connPhone;
		DBusError errPhone;
		int retPhone;
		DBusPendingCall* pendingPhone;
		int stat;
		dbus_uint32_t level;
		const char* paramPhone;

		int connectedLock;
		DBusMessage* msgLock;
		DBusMessageIter argsLock;
		DBusConnection* connLock;
		DBusError errLock;
		int retLock;
		const char* sigvalueLock;

		int connectedVib;
		DBusMessage* msgVib;
		DBusMessageIter argsVib;
		DBusConnection* connVib;
		DBusError errVib;
		DBusPendingCall* pendingVib;
		int retVib;
		const char* paramVib;
		
		int connectedProx;
		DBusMessage* msgProx;
		DBusMessageIter argsProx;
		DBusConnection* connProx;
		DBusError errProx;
		int retProx;
		const char* sigvalueProx;
		
		void connectToDbusVibra();
		void vibrate(int type);
		
		void connectToDbusLock();
		void checkLock();
		
		void connectToDbusPhone();
		void launchPhone();
	

		void connectToDbusProx();
		
		DBusMessage* msgProxSen;
		DBusMessageIter argsProxSen;
		DBusPendingCall* pendingProxSen;

		
		int ppid;
		void startSensor();
		void stopSensor();
		
		void dash();
		
		char readProx();

		
	public:
		ProximitySensor();
		~ProximitySensor();
		void checkSensor();	
		int interval;
		void start();
		
};

#endif
