#include "config.h"

Config* Config::me=NULL;

Config::Config(ProximitySensor* ps_, CameraKey* ck_)
{
	configFile="/home/user/.shortcutd/config";
	input = fopen(configFile,"r");
	init_JSON_config(&config);

	config.depth = 20;
	config.callback = &handleResult;
	config.allow_comments = 1;
	config.handle_floats_manually = 0;
	jc = new_JSON_parser(&config);		    
	count=0;
	s_IsKey=0;
	proximityOn=1;
	ps=ps_;
	ck=ck_;
	
	me=this;
}

void Config::setProximity(ProximitySensor* ps_)
{
ps=ps_;
}

void Config::setCameraKey(CameraKey* ck_)
{
ck=ck_;
}

int Config::readConfig()
{

	
	for (; input ; ++count) 
	{
		int next_char = fgetc(input);
		if (next_char <= 0) 
		{
			break;
		}
		if (!JSON_parser_char(jc, next_char)) 
		{
			delete_JSON_parser(jc);
			DebugPrint("JSON_parser_char: syntax error");
			return 1;
		}
	}
        
	if (!JSON_parser_done(jc)) 
	{
		delete_JSON_parser(jc);
		DebugPrint("JSON_parser_end: syntax error");
		return 1;
	}
	
	

return 0;
}

void Config::setInt(int value_)
{


	if (key.compare("proximityOn")==0)
		proximityOn=value_;	

	
	DebugPrint("config SET: ");
	DebugPrint(key);
	DebugPrint(value_);

}


void Config::setString(std::string value_)
{

	if (key.compare("thisIsString")==0)
		std::cout<<"SET: "<<value_<<std::endl;

	
}


int Config::handleResult(void* ctx, int type, const JSON_value* value)
{
switch(type)
    {
    case JSON_T_ARRAY_BEGIN:
        me->s_IsKey = 0;
        break;
    case JSON_T_ARRAY_END:
        assert(!me->s_IsKey);
        break;
   case JSON_T_OBJECT_BEGIN:
       me->s_IsKey = 0;
       break;
    case JSON_T_OBJECT_END:
        assert(!me->s_IsKey);
        break;
    case JSON_T_INTEGER:
        me->s_IsKey = 0;
	me->setInt(value->vu.integer_value);
        break;
    case JSON_T_FLOAT:
        me->s_IsKey = 0;
        break;
    case JSON_T_NULL:
        me->s_IsKey = 0;
        break;
    case JSON_T_TRUE:
        me->s_IsKey = 0;
        break;
    case JSON_T_FALSE:
        me->s_IsKey = 0;
        break;
    case JSON_T_KEY:
        me->s_IsKey = 1;
	me->key=value->vu.str.value;
        break;
    case JSON_T_STRING:
        me->s_IsKey = 0;
	me->setString(value->vu.str.value);
        break;
    default:
        assert(0);
        break;
    }

return 1;

}


