#include "camkey.h"
#include "shortcutd.h"

DBusError CameraKey::dbus_err;
LibHalContext* CameraKey::halctx;
int CameraKey::shutter_state;
Display* CameraKey::dpy;


CameraKey::CameraKey()
{
	shutter_state = 0;
	initSuccess = false;
}

CameraKey::~CameraKey()
{
    const char* hal_udi_camfocus = "/org/freedesktop/Hal/devices/platform_cam_focus";
    const char* hal_udi_shutter = "/org/freedesktop/Hal/devices/platform_cam_shutter";

	if( initSuccess )
	{
	    libhal_device_remove_property_watch(halctx, hal_udi_shutter, &dbus_err);
	    libhal_device_remove_property_watch(halctx, hal_udi_camfocus, &dbus_err);
	    libhal_ctx_shutdown(halctx, &dbus_err);
	    libhal_ctx_free(halctx);
	    dbus_connection_unref(dbus_sys);
	}
}

bool CameraKey::Init()
{
    const char* hal_udi_camfocus = "/org/freedesktop/Hal/devices/platform_cam_focus";
    const char* hal_udi_shutter = "/org/freedesktop/Hal/devices/platform_cam_shutter";

    dpy = XOpenDisplay(NULL);
    if ( dpy == NULL )
    {
        DebugPrint("ck init: failed to open display");
		return false;
    }

    halctx = libhal_ctx_new();
    dbus_sys = dbus_bus_get(DBUS_BUS_SYSTEM, &dbus_err);
        if ( dbus_error_is_set(&dbus_err) || dbus_sys==NULL ) {
        DebugPrint("ck init: system dbus init fail");
        return false;
    }
    //dbus_connection_setup_with_g_main(dbus_sys, NULL);
    if( !libhal_ctx_set_dbus_connection(halctx, dbus_sys) )
    {
        DebugPrint("ck init: hal dbus connection fail");
        return false;
    }
    if( !libhal_ctx_init(halctx, &dbus_err) )
    {
        DebugPrint("ck init: hal init fail");
        return false;
    }

    libhal_ctx_set_device_property_modified(halctx, CameraKey::PropertyModified);
    libhal_device_add_property_watch(halctx, hal_udi_shutter, &dbus_err);
    libhal_device_add_property_watch(halctx, hal_udi_camfocus, &dbus_err);

    shutter_state = libhal_device_get_property_bool(halctx, hal_udi_shutter,
        "button.state.value", &dbus_err);

	initSuccess = true;	
	return true;
}

void CameraKey::PropertyModified( LibHalContext* ctx, const char* udi, const char* key,
                            dbus_bool_t is_removed, dbus_bool_t is_added)
{
	const char* hal_udi_camfocus = "/org/freedesktop/Hal/devices/platform_cam_focus";
	const char* hal_udi_shutter = "/org/freedesktop/Hal/devices/platform_cam_shutter";

    //printf("hal property callback %s: %s\n", udi, key);
    int state = libhal_device_get_property_bool(halctx, udi, "button.state.value", &dbus_err);

    if( strcmp(udi, hal_udi_shutter)==0 )
    {
		DebugPrint("cam shutter state change");
        shutter_state = state;
    }

    if( strcmp(udi, hal_udi_camfocus)==0 && shutter_state==1 && state==1 )
    {
		DebugPrint("cam focus key event, sending ctrl-bs");
        CameraKey::SendCtrlBackspace();
    }
}


void CameraKey::SendCtrlBackspace()
{
    // 37 - ctrl
    // 22 - backspace

    int keycode = 37;
    int is_down = 1;

    XTestFakeKeyEvent(dpy, keycode, is_down, 0);
    XSync(dpy, 1);

    keycode = 22;
    is_down = 1;

    XTestFakeKeyEvent(dpy, keycode, is_down, 0);
    XSync(dpy, 1);

    keycode = 22;
    is_down = 0;

    XTestFakeKeyEvent(dpy, keycode, is_down, 0);
    XSync(dpy, 1);

    keycode = 37;
    is_down = 0;

    XTestFakeKeyEvent(dpy, keycode, is_down, 0);
    XSync(dpy, 1);
}

DBusConnection* CameraKey::GetSysDBus()
{
	return dbus_sys;
}
