/* Shopper
 * Copyright (C) 2008 David Greaves <david@dgreaves.com>
 *
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#ifndef SHOPPER_UI_LISTDIALOG_H
#define SHOPPER_UI_LISTDIALOG_H
#include "shopperList.h"
#include <QDialog>

class QWidget;
class QCheckBox;

namespace Shopper
{
// Menu for making a list
	class ListDialog : public QDialog
	{
		Q_OBJECT;
	public:
		ListDialog(QWidget * parent, Shopper::List*);

	public slots:
		void on_action_clear_wanted();
		void on_action_clear_notes();
		void on_action_clear_bought();
		void on_action_making_list();
	private:
		QCheckBox*     clearW_c;
		QCheckBox*     clearN_c;
		QCheckBox*     clearB_c;
		Shopper::List  *mylist;
	};
};
#endif
