/* Shopper
 * Copyright (C) 2008 David Greaves <david@dgreaves.com>
 *
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
//#define DEBUG_SHOPPER 1
#include "ListDialog.h"
#include "shopper.h"           // automake, i8n, gettext

#include "CategoryDialog.h"
#include "GestureWatcher.h"
//#include "AppearWidget.h"

#include <QLabel>
#include <QLineEdit>
#include <QComboBox>
#include <QDialogButtonBox>
#include <QPushButton>
#include <QHBoxLayout>
#include <QGridLayout>
#include <QCheckBox>

namespace Shopper
{
////////////////////////////////////////////////////////////////

	ListDialog::ListDialog( QWidget * parent, Shopper::List* list) :
		QDialog(parent),
		mylist(list)
	{
		_ENTER;
		// Create some fancy components
		QLabel* clearW_l = new QLabel(tr("Clear Wanted"));
		QLabel* clearN_l = new QLabel(tr("Clear All Notes"));
		QLabel* clearB_l = new QLabel(tr("Empty Basket"));

		clearW_c = new QCheckBox();
		clearN_c = new QCheckBox();
		clearB_c = new QCheckBox();

		QPushButton* clearW_b = new QPushButton(tr("Clear"));
		connect(clearW_b, SIGNAL(clicked()),
				this, SLOT(on_action_clear_wanted()));

		QPushButton* clearN_b = new QPushButton(tr("Clear"));
		connect(clearN_b, SIGNAL(clicked()),
				this, SLOT(on_action_clear_notes()));

		QPushButton* clearB_b = new QPushButton(tr("Empty"));
		connect(clearB_b, SIGNAL(clicked()),
				this, SLOT(on_action_clear_bought()));

		QPushButton* edit_b = new QPushButton(tr("Choose Shopping"));
		connect(edit_b, SIGNAL(clicked()),
				this, SLOT(on_action_making_list()));

		QWidget *dialog_area = new QWidget();
        QGridLayout *grid = new QGridLayout(dialog_area);
		// Use the grid as the Dialog layout
		setLayout(grid);

		grid->setColumnStretch(0,1);
		grid->addWidget(clearW_l, 0, 0);
		grid->addWidget(clearN_l, 1, 0);
		grid->addWidget(clearB_l, 2, 0);

		grid->setColumnMinimumWidth(1,10);

		grid->addWidget(clearW_c, 0, 2);
		grid->addWidget(clearN_c, 1, 2);
		grid->addWidget(clearB_c, 2, 2);
		
		grid->setColumnMinimumWidth(3,10);

		grid->addWidget(clearW_b, 0, 4);
		grid->addWidget(clearN_b, 1, 4);
		grid->addWidget(clearB_b, 2, 4);

		grid->setRowMinimumHeight(3,20);
		grid->addWidget(edit_b, 4, 1, 1, 4, Qt::AlignHCenter );

		// Prepare a scene for the widgets
//		QGraphicsScene *scene = new QGraphicsScene(this);
		// Lay them out in  a grid inside a graphical widget
//      QGraphicsWidget *dialog_graphical = new QGraphicsWidget();
		// Layout the appearwidgets

		// in the scene
//		scene->addItem(dialog_graphical);

		// and create a view on the scene
//      QGraphicsView *view = new QGraphicsView(scene);
		// add the view to the dialog area widget
		// and put the dialog area widget in the dialog

//		dialog_area->setMinimumHeight(250);
//		dialog_area->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Minimum);
		
	}
	
	void ListDialog::on_action_clear_wanted() {
		mylist->clear(Shopper::CLEAR_WANTED);
		accept();
	}
	void ListDialog::on_action_clear_notes() {
		mylist->clear(Shopper::CLEAR_NOTES);
		accept();
	}
	void ListDialog::on_action_clear_bought() {
		mylist->clear(Shopper::CLEAR_BOUGHT);
		accept();
	}

	void ListDialog::on_action_making_list() {
		if (clearW_c->isChecked())
			mylist->clear(Shopper::CLEAR_WANTED);
		if (clearN_c->isChecked())
			mylist->clear(Shopper::CLEAR_NOTES);
		if (clearB_c->isChecked())
			mylist->clear(Shopper::CLEAR_BOUGHT);
		mylist->set_state(Shopper::MAKING_LIST);
		accept();
	}
}
