#include "shopper.h"
#include "ListImport.h"
#include "List.h"

#include <cctype>

#include <string>
#include <iostream>
#include <fstream>
#include <sstream>

#include <QString>

namespace Shopper {

List* ListImport::from_plaintext(QString filename) {
	std::ifstream file(filename.toAscii());
	if (!file) {
		return 0;
	}
	// convert to xml
	std::stringstream xml;

	xml << "<list name='" << filename << "' state='2'>";

	int categoryId = 0;
	bool categoryStarted = false;
	std::string line;
	while (std::getline(file, line)) {
		if (line.size() > 0 && !isspace(line[0])) {
			if (categoryStarted)
				xml << "</category>";

			xml << "<category name='" << line << "' id='" << categoryId++ << "'>";
			categoryStarted = true;
		}

		if (line.size() >= 1 && isspace(line[0])) {
			if (!categoryStarted) {
				xml << "<category name='no category' id='" << categoryId++ << "'>";
				categoryStarted = true;
			}

			line.erase(0, line.find_first_not_of(" \t\n\r\f"));
			if (line.size() > 0)
				xml << "<item wanted='1' bought='0' desc='" << line << "' note=''/>";
		}
	}

	if (categoryStarted)
		xml << "</category>";
	xml << "</list>";

	std::string sxml(xml.str());
	QString qxml(sxml.c_str());
	DEBUG("import from : " <<filename <<"\n"<<qxml);

	return new Shopper::List(qxml);
}

}
