/* Shopper
 * Copyright (C) 2008 David Greaves <david@dgreaves.com>
 *
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
//#define DEBUG_SHOPPER 1
#include "SaveDialog.h"
#include "shopper.h"           // automake, i8n, gettext

#include <QPushButton>
#include <QGridLayout>

namespace Shopper
{
////////////////////////////////////////////////////////////////

	SaveDialog::SaveDialog( QWidget * parent, MainWindow *mw) :
		QDialog(parent)
	{
		_ENTER;
		QPushButton* saveAs_b = new QPushButton(tr("Save As"));
		connect(saveAs_b, SIGNAL(clicked()),
				mw, SLOT(on_action_saveas()));
		connect(saveAs_b, SIGNAL(clicked()),
				this, SLOT(accept()));

		QPushButton* load_b = new QPushButton(tr("Load"));
		connect(load_b, SIGNAL(clicked()),
				mw, SLOT(on_action_file_open()));
		connect(load_b, SIGNAL(clicked()),
				this, SLOT(accept()));

		QPushButton* new_b = new QPushButton(tr("New"));
		connect(new_b, SIGNAL(clicked()),
				mw, SLOT(on_action_file_new()));
		connect(new_b, SIGNAL(clicked()),
				this, SLOT(accept()));

		QWidget *dialog_area = new QWidget();
        QGridLayout *grid = new QGridLayout(dialog_area);
		// Use the grid as the Dialog layout
		setLayout(grid);

		grid->addWidget(saveAs_b, 0, 0);
		grid->addWidget(load_b, 1, 0);
		grid->addWidget(new_b, 2, 0);
	}
}

