/* Shopper
 * Copyright (C) 2008 David Greaves <david@dgreaves.com>
 *
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#define DEBUG_SHOPPER 1

// Wraps a widget and applies a transform to make it appear when 'polish' is called

#include "AppearWidget.h"

AppearWidget::AppearWidget(QWidget *child, QGraphicsItem *parent)
    : QGraphicsProxyWidget(parent),
	  wrap(child)
{
	wrap->installEventFilter(this);
    setWidget(wrap);

    // The states and animations.
    QStateMachine *machine = new QStateMachine(this);
    QState *s0 = new QState(machine);
    s0->assignProperty(this, "rotation", 0);
    machine->setInitialState(s0);

    QState *s1 = new QState(machine);
    s1->assignProperty(this, "rotation", 90);

    QSignalTransition *t1 = s0->addTransition(this, SIGNAL(appear()), s1);
	int c = connect(this, SIGNAL(appear()), this, SLOT(print()));
	qDebug() << "connect " << c;
	QPropertyAnimation *yRotationAnim = new QPropertyAnimation(this, "rotation");
    yRotationAnim->setDuration(2000);
    t1->addAnimation(yRotationAnim);

    connect(yRotationAnim, SIGNAL(valueChanged(const QVariant&)),
			this, SLOT(print(const QVariant&)));
	
	machine->start();
}

void AppearWidget::resizeEvent(QGraphicsSceneResizeEvent *event)
{
    QSizeF siz = event->newSize();
    QPointF pt = QPointF(siz.width() / 2, siz.height() / 2);
    setTransformOriginPoint(pt);
}

bool AppearWidget::eventFilter(QObject *obj, QEvent *event)
{
	if (event->type() != QEvent::Polish)
		return QGraphicsProxyWidget::eventFilter(obj, event);
	QString s = QString::number(this->receivers(SIGNAL(appear())));
	DEBUG(s);
	emit appear();
	s = QString::number(this->receivers(SIGNAL(appear())));
	DEBUG(s);
	DEBUG("Appear");
	return QGraphicsProxyWidget::eventFilter(obj, event);
}

void AppearWidget::print(const QVariant &value)
{
	DEBUG("Value ");
	qDebug() << value ;
}
void AppearWidget::print()
{
	DEBUG("slot printed");
}

