#include "shopper.h"
#include "ListImport.h"
#include "List.h"

#include <cctype>

#include <string>
#include <iostream>
#include <fstream>
#include <sstream>

#include <QString>

namespace Shopper {

List* ListImport::from_plaintext(QString filename) {
	QFile file(filename);
	if (!file.open(QIODevice::ReadOnly | QIODevice::Text)) {
			return 0;
	}
	// convert to xml
	QString xmlStr;
	QTextStream xml(&xmlStr);
	QTextStream in(&file);
	xml << "<list name='" << filename << "' state='2'>";

	int categoryId = 0;
	bool categoryStarted = false;
	QString line;
	while (!in.atEnd()){
		line = in.readLine();
		if (line.size() > 0 && !line[0].isSpace()) {
			if (categoryStarted)
				xml << "</category>";

			xml << "<category name='" << line << "' id='" << categoryId++ << "'>";
			categoryStarted = true;
		}

		if (line.size() >= 1 && line[0].isSpace()) {
			if (!categoryStarted) {
				xml << "<category name='no category' id='" << categoryId++ << "'>";
				categoryStarted = true;
			}

			int c=0;
			while (line[c].isSpace() and c++ < line.size()) {
				if (c) line.remove(0,c);
			}
			if (line.size() > 0)
				xml << "<item wanted='1' bought='0' desc='" << line << "' note=''/>";
		}
	}

	if (categoryStarted)
		xml << "</category>";
	xml << "</list>";

	DEBUG("import from : " <<filename <<"\n"<<xml);

	return new Shopper::List(xmlStr);
}

}
