#include "view.h"

Game* View::game=NULL;


View::View(QGraphicsScene* scene_):QGraphicsView(scene_)
{
	scene=scene_;
	Poi* poi=new Poi(380,220,48,-90,0);
	poi->setPos(poi->x,poi->y);
	pois.push_back(poi);
	scene->addItem(poi);

	clock= new Clock();
	scene->addItem(clock);

	 QTimer* timerClock = new QTimer(this);
	 connect(timerClock, SIGNAL(timeout()), clock, SLOT(tick()));
	 timerClock->start(1000);
			 


	Icon* icon = new Icon(0); //exit
	icon->x=750;
	icon->y=40;
	icons.push_back(icon);
	scene->addItem(icon);
	activeIcon=NULL;
	 
	
	Icon* icon2 = new Icon(1); //sound
	icon2->x=650;
	icon2->y=40;
	icons.push_back(icon2);
	scene->addItem(icon2);
	
	Icon* icon3 = new Icon(2); //pause
	icon3->x=550;
	icon3->y=40;
	icons.push_back(icon3);
	scene->addItem(icon3);
	
	Platform* platform=new Platform(200,20,80,90,0,1);
	platform->setPos(platform->x,platform->y);
	platforms.push_back(platform);
	scene->addItem(platform);

	Fence* fence = new Fence();
	fence->x=300;
	fence->y=300;
	fence->cRotation=30;
	fences.push_back(fence);
	scene->addItem(fence);

				
	fence = new Fence();
	fence->x=30;
	fence->y=100;
	fence->cRotation=60;
	fence->dRotation=1;
	fences.push_back(fence);
	fence->active=0;
	scene->addItem(fence);

	platform->addFence(fence);
	
	fence = new Fence();
	fence->x=600;
	fence->y=150;
	fence->cRotation=240;
	fence->active=0;
	fences.push_back(fence);
	scene->addItem(fence);


	platform->addFence(fence);
	
	
	

}

void View::win()
{

	
	infoLayout = new QGridLayout;
	
	/*
	QInputDialog* username= new QInputDialog();
	username->setOkButtonText(QString("Ok"));
	username->setTextValue(QString("Twitter username"));
	username->setLabelText(QString(""));
 	*/

	username = new QLineEdit();
	username->setPlaceholderText(QString("Twitter username"));


	
	password = new QLineEdit();
	password->setPlaceholderText(QString("Twitter password"));

	

	ok = new QPushButton(QString("OK"),this);
	cancel = new QPushButton(QString("Cancel"),this);
	
	QWidget::connect(ok,SIGNAL(clicked()),this,SLOT(twitOk()));
	QWidget::connect(cancel,SIGNAL(clicked()),this,SLOT(twitCancel()));
	
	//password->setFrame(false);
	//username->setFrame(false);
	
	infoLayout->addWidget(username,20,0);
	infoLayout->addWidget(password,21,0);
	infoLayout->addWidget(ok,22,0);
	infoLayout->addWidget(cancel,22,1);
	
	for (int i=0;i<23;++i)
		infoLayout->setRowMinimumHeight(i,10);
	
	setLayout(infoLayout);
	
	
	 
	
	

}


void View::twitOk()
{


	
	ok->setText(QString("Updating status"));
	
	
	 twitCurl* twit=new twitCurl();

	 std::string usernameS = std::string(username->text().toStdString());
	 std::string passwordS = std::string(password->text().toStdString());

	 
	 
	 twit->setTwitterUsername(usernameS);
	 twit->setTwitterPassword(passwordS);
	 
	 
	 std::string status = std::string("I just scored ");
	status.append(QString::number(1000-game->score).toStdString());
	status.append(" points in #Sheep");
	 

  
	 
	if (!twit->statusUpdate(status))
		ok->setText(QString("Update failed"));
	else
		ok->setText(QString("Update successful"));



	cancel->setText("Exit");
	


}

void View::twitCancel()
{

	game->app->quit();
}




void View::mousePressEvent(QMouseEvent* event)
{
		for (int i=0;i<icons.size();++i)
		{
			if (icons[i]->boundingRect().contains(event->globalX()-icons[i]->x,event->globalY()-icons[i]->y))
			{
				activeIcon=icons[i];
				activeIcon->inMove=1;
				//std::cout<<"icon pressed"<<std::endl;
				return;		
			}

		}	
	
		if (pois.size()>10)
			return;

		if (game->pauseOn)
			return;
		
		poi=new Poi(event->globalX(),event->globalY(),86,40,1);
		poi->setPos(event->globalX(),event->globalY());
		connect(poi,SIGNAL(deleteMe(Poi*)),this,SLOT(removeItem(Poi*)));
		pois.push_back(poi);
		scene->addItem(poi);
}


void View::mouseMoveEvent(QMouseEvent* event)
{
	//std::cout<<event->globalX()<<std::endl;
	if (activeIcon!=NULL)
		activeIcon->move(event->globalX(),event->globalY());


}

void View::mouseReleaseEvent(QMouseEvent* event)
{	
	if (activeIcon!=NULL)
	{
		activeIcon->inMove=0;
		activeIcon=NULL;
	}
}



void View::removeItem(Poi* poi)
{
	for (int i=0;i<pois.size();++i)
	{
		if (pois[i]==poi && poi!=NULL)
		{
			delete poi;
			pois.erase(pois.begin()+i);
			return;
		}

	}

}


void View::rewindBackgroundSound()
{
	std::cout<<"Rewinding"<<std::endl;
	game->soundEngine->background->seek(1);
}
