#include "sheep.h"

 #include <QGraphicsScene>
 #include <QPainter>
 #include <QStyleOption>
#include <fence.h>
 #include <math.h>


Game* Sheep::game=NULL;
View* Sheep::view=NULL; 


 
Sheep::Sheep(): angle(0), speed(0)
{

	setZValue(sheepDepth);
	objType=1;
	vec=new Vec(0,0);
	movVec=new Vec(0,0);
	colVec=new Vec(0,0);
	counter=0;
	active=1;
}

 
QRectF Sheep::boundingRect() const
{
	return QRectF(0,0,33,65);
}

 QPainterPath Sheep::shape() const
 {
     QPainterPath path;
     path.addEllipse(boundingRect());
     return path;
 }

 void Sheep::paint(QPainter *painter, const QStyleOptionGraphicsItem *, QWidget *)
 {

	painter->drawPixmap(0,0,game->sheepPix);
/*
	painter->setPen(scene()->collidingItems(this).isEmpty() ? Qt::white : Qt::red);
	painter->drawRect(boundingRect());
	painter->setPen(active ? Qt::white : Qt::yellow );
	painter->drawEllipse(boundingRect());
	painter->translate(game->sheepPix.width()/2,game->sheepPix.height()/2);
	painter->rotate(-cRotation);
	painter->setPen(Qt::blue);
	painter->drawLine(0,0,vec->x,vec->y);
	painter->setPen(Qt::red);
	painter->drawLine(0,0,movVec->x,movVec->y);
	painter->setPen(Qt::yellow);
	painter->drawLine(0,0,colVec->x,colVec->y);
*/	
 }




 void Sheep::advance(int step)
 {
     if (!step || active==0 || game->pauseOn)
         return;
 

	qreal oldX=x;
	qreal oldY=y;

	

	for (int i=0; i<view->fences.size();++i)
	{

		qreal distanceFence = sqrt(pow(x+game->sheepPix.width()/2-view->fences[i]->x-game->fencePix.width()/2,2)+pow(y+game->sheepPix.height()/2-view->fences[i]->y-game->fencePix.height()/2,2));


		if (distanceFence<20 && view->fences[i]->active==1)
		{
	//		std::cout<<"caught"<<std::endl;
	//		active=0;
	//		view->fences[i]->active=0;
			view->fences[i]->addSheep(this);
			return;
		}
	}

	
	for (int i=0;i<view->platforms.size();++i)
	{

//		qreal distancePlatform = sqrt(pow(x+game->sheepPix.width()/2-view->platforms[i]->x-view->platforms[i]->sizeX/2,2)+pow(y+game->sheepPix.height()/2-view->platforms[i]->y-view->platforms[i]->sizeY/2,2));
		
		if (view->platforms[i]->boundingRect().contains(-view->platforms[i]->x+x+game->sheepPix.width()/2,-view->platforms[i]->y+y+game->sheepPix.height()/2))
		{
	//		++view->platforms[i]->sheepCounter;
			view->platforms[i]->addSheep(this);
		}
		

	}


	
	{

	
	   
	vec->clear();
	movVec->clear();
     	colVec->clear();
     
	if (scene()->collidingItems(this).count()>0)
	{
		
		for (int i=0;i<scene()->collidingItems(this).count();++i)
		{
			if (((Sheep*)(scene()->collidingItems(this)[i]))->objType==1) //sheep
			{
				colVec->add(((Sheep*)(scene()->collidingItems(this)[i]))->x-x,((Sheep*)(scene()->collidingItems(this)[i]))->y-y);
				break;
			}
			
				qreal distanceFence = sqrt(pow(x+game->sheepPix.width()/2-((Fence*)(scene()->collidingItems(this)[i]))->x-game->fencePix.width()/2,2)+pow(y+game->sheepPix.height()/2-((Fence*)(scene()->collidingItems(this)[i]))->y-game->fencePix.height()/2,2));
			
			if (((Sheep*)(scene()->collidingItems(this)[i]))->objType==2 && distanceFence>=50) //fence
			{

				
				colVec->add(((Fence*)(scene()->collidingItems(this)[i]))->x+game->fencePix.width()/2-x-game->sheepPix.width()/2,((Fence*)(scene()->collidingItems(this)[i]))->y+game->fencePix.height()/2-y-game->sheepPix.height()/2);
			}
			else if (((Sheep*)(scene()->collidingItems(this)[i]))->objType==2 && distanceFence<50) //fence
			{
				
				qreal XX=((Fence*)(scene()->collidingItems(this)[i]))->x+game->fencePix.width()/2-x-game->sheepPix.width()/2;
				qreal YY=((Fence*)(scene()->collidingItems(this)[i]))->y+game->fencePix.height()/2-y-game->sheepPix.height()/2;
				colVec->add(-XX,-YY);
			}

			else if (((Sheep*)(scene()->collidingItems(this)[i]))->objType==0 && ((Poi*)(scene()->collidingItems(this)[i]))->type==0) //dog 
			{
				colVec->add(((Poi*)(scene()->collidingItems(this)[i]))->x+((Poi*)(scene()->collidingItems(this)[i]))->value/2-x-game->sheepPix.width()/2,((Poi*)(scene()->collidingItems(this)[i]))->y+((Poi*)(scene()->collidingItems(this)[i]))->value/2-y-game->sheepPix.height()/2);
				break;
			}
		}

		
	}

 	for (int i=0; i<view->pois.size();++i)
	{

		qreal dx=view->pois[i]->x+abs(view->pois[i]->value/2.0)-(x+game->sheepPix.width()/2);
		qreal dy=view->pois[i]->y+abs(view->pois[i]->value/2.0)-(y+game->sheepPix.height()/2);
		                
		qreal dist = sqrt(pow(dx,2)+pow(dy,2));
	
		qreal vecX;
		qreal vecY;
								
		vecX=dx/(pow(dist,2))*view->pois[i]->attraction*50;
		vecY=dy/(pow(dist,2))*view->pois[i]->attraction*50;

		if (sqrt(pow(vecX,2)+pow(vecY,2))>5)
			vec->add(vecX,vecY);
		else
			vec->add(0.01,0.01);
	}
	

	 setTransformOriginPoint(game->sheepPix.width()/2,game->sheepPix.height()/2);


	qreal dr;
	
	if ((cRotation < vec->getAngle() && cRotation- vec->getAngle() > -200) || (cRotation - vec->getAngle() > 200))
	{
		cRotation+=2;
		if (cRotation > vec->getAngle()) //add +5 here and -5 below to have jerky movement
		{
		//	std::cout<<cRotation<<std::endl;
			cRotation=vec->getAngle();
		}
	}
	else
	{
		cRotation-=2;
		if (cRotation < vec->getAngle())
		{
		//	std::cout<<cRotation<<std::endl;
			cRotation=vec->getAngle();
		}
	}

	dr=-cRotation + vec->getAngle();
       	if (dr< -15)
		dr=-15;
	if (dr > 15)
		dr=15;	
	
	

	qreal d = std::min(60.0,sqrt(pow(vec->x,2)+pow(vec->y,2)));
	
	qreal xx = d * cos ((cRotation-90+dr)*0.0174532925)-colVec->x; 
	qreal yy = d * sin ((cRotation-90+dr)*0.0174532925)-colVec->y;
	

	
	
	movVec->add(xx,yy);
	
	x+=xx/50;
	y+=yy/50;

	
	

	if (x < 20)
		x=20;
	if (x > 720)
		x=720;
	if (y < 20)
		y=20;
	if (y > 400)
		y=400;
		
	
	 
		
		
	setPos(x,y);  
     	setRotation(cRotation);

     
	}
       
	}

