#ifndef GAME_H
#define GAME_H

#include <QWidget>
#include <QGraphicsScene>
#include <QGraphicsView>
#include "libmctacc.h"
#include <glib.h>
#include <dbus/dbus.h>
#include <soundengine.h>
#include <view.h>

class SoundEngine;
class View;

class Game: public QWidget
{
public:
	Game();
	QPixmap sheepPix;
	QPixmap fencePix;
	QPixmap fenceClosedPix;
	QPixmap grassPix;
	QPixmap dogPix;
	QPixmap iconExitPix;
	QPixmap iconSoundOnPix;
	QPixmap iconSoundOffPix;
	QPixmap iconPlayPix;
	QPixmap iconPausePix;

	AccSensor* acc;

	int pauseOn;

	int sheepToHerd;
	
	qreal levelZeroX;
	qreal levelZeroY;

	qreal lastX;
	qreal lastY;
	qreal lastZ;

	static View* view;
	
	void vibrate(int type);
	void connectToDbusVibra();

	int connectedVib;
	DBusMessage* msgVib;
	DBusMessageIter argsVib;
	DBusConnection* connVib;
	DBusError errVib;
	DBusPendingCall* pendingVib;
	int retVib;
	const char* paramVib;
	
		
	void startBackground();
	void stopBackground();
	pthread_t backgroundThread;

	int backgroundPlaying;
	
	SoundEngine* soundEngine;	
	
	int sound;

	void caught();
	void win();
	int won;

	int score;

	QApplication* app;
	
};




#endif
