#include "vec.h"


Vec::Vec(qreal x_, qreal y_):x(x_),y(y_)
{


}


void Vec::add(qreal x_, qreal y_)
{

	x+=x_;
	y+=y_;
}

void Vec::clear()
{
	x=0;
	y=0;
}

qreal Vec::getAngle()
{
	qreal d = sqrt(pow(x,2)+pow(y,2));
	qreal ny = y/d;
	qreal nx = x/d;

	if (nx>0)
		return 180-acos(ny)*57.2957795;
	else
		return acos(ny)*57.2957795-180;
}

