#ifndef SHEEP_H
#define SHEEP_H

#include <QGraphicsItem>
#include <game.h>
#include <vec.h>
#include <view.h>
#include <algorithm>
#include <baseobj.h>

class View;
class Game;

class Sheep : public QGraphicsItem, public BaseObj
{
public:

   	Sheep();
      	QRectF boundingRect() const;
	QPainterPath shape() const;
   	void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget);
	Vec* vec;
	Vec* movVec;
	Vec* colVec;
      	static Game* game;
	static View* view;
	qreal x;
	qreal y;
	qreal cRotation;
	qreal xBefore;
	qreal yBefore;
	qreal counter;
	int active;
     
protected:
	void advance(int step);

private:
	qreal angle;
   	qreal speed;
	
};

#endif

