#include "sheep.h"
#include "game.h"
#include "view.h"
#include <QtGui>
#include <fence.h>
#include <twitcurl.h>

 #include <math.h>

 static const int sheepCount = 5;


 
 int main(int argc, char **argv)
 {
 QApplication app(argc, argv);

 qsrand(QTime(0,0,0).secsTo(QTime::currentTime()));


      app.setApplicationName("Sheep");

	Game* game = new Game;
	Clock::game=game;
     	Poi::game=game;
	Sheep::game=game;
	Fence::game=game;
	Icon::game=game;
	Platform::game=game;

	game->app=&app;	
     QGraphicsScene scene;
     scene.setSceneRect(0, 0, 800, 480);
     scene.setItemIndexMethod(QGraphicsScene::NoIndex);
  	View* view = new View(&scene);

	Game::view=view;
	View::game=game;
	Sheep::view=view;
	Fence::view=view;

     for (int i = 0; i < sheepCount; ++i) 
     {
         Sheep *sheep = new Sheep();
         sheep->x=150*(i+1);
	 sheep->y=120*i;
	 sheep->setPos(sheep->x,sheep->y);
	 scene.addItem(sheep);
     }


     
  
     view->setRenderHint(QPainter::Antialiasing);
     view->setBackgroundBrush(QPixmap("/home/opt/sheep/images/field.png"));
    view->setCacheMode(QGraphicsView::CacheNone);
    view->setViewportUpdateMode(QGraphicsView::FullViewportUpdate);
     view->setWindowTitle(QT_TRANSLATE_NOOP(QGraphicsView, "Sheep"));
     view->resize(800, 480);
     view->showFullScreen();

     QTimer timer;
     QObject::connect(&timer, SIGNAL(timeout()), &scene, SLOT(advance()));
     timer.start(1000 / 33);

     return app.exec();
 }
